<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package niche_blog
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="blog-post-item">
		<?php if ( has_post_thumbnail() ) : ?>
			<div class="featured-image">
				<?php niche_blog_post_thumbnail(); ?>
			</div><!-- .featured-image -->
        <?php endif; ?>

        <?php 
		if ( 'post' === get_post_type() && ! get_theme_mod( 'hide_entry_meta', false ) ) :
			?>
			<div class="entry-meta">
				<?php
					niche_blog_posted_by();
					niche_blog_posted_on();
				?>
			</div><!-- .entry-meta -->			
		<?php endif; ?>

		<div class="entry-container">
	        <header class="entry-header">
				<?php
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif; ?>
			</header><!-- .entry-header -->

			<div class="entry-content">
				<?php the_content(); ?>
			</div><!-- .entry-content -->

			<footer class="entry-footer">
				<?php niche_blog_entry_footer(); ?>
			</footer><!-- .entry-footer -->
		</div><!-- .entry-container -->
	</div><!-- .blog-post-item -->
</article><!-- #post-<?php the_ID(); ?> -->