<?php
/**
 * Theme Options.
 *
 * @package niche_blog
 */

// Add Panel.
$wp_customize->add_panel( 'theme_option_panel',
	array(
	'title'      => __( 'Niche Blog Options', 'niche-blog' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	)
);

// Sidebar section
$wp_customize->add_section('section_sidebar', array(    
	'title'       => __('Sidebar', 'niche-blog'),
	'panel'       => 'theme_option_panel'    
));

// Blog Sidebar Option
$wp_customize->add_setting('blog_sidebar', 
	array(
	'default' 			=> 'no-sidebar',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
	)
);

$wp_customize->add_control('blog_sidebar', 
	array(		
	'label' 	=> __('Blog Page Sidebar', 'niche-blog'),
	'section' 	=> 'section_sidebar',
	'settings'  => 'blog_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'niche-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'niche-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'niche-blog'),	
		),	
	)
);

// Single Post Sidebar Option
$wp_customize->add_setting('single_post_sidebar', 
	array(
	'default' 			=> 'right-sidebar',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
	)
);

$wp_customize->add_control('single_post_sidebar', 
	array(		
	'label' 	=> __('Single Post Sidebar', 'niche-blog'),
	'section' 	=> 'section_sidebar',
	'settings'  => 'single_post_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'niche-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'niche-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'niche-blog'),	
		),	
	)
);

// Archive Sidebar Option
$wp_customize->add_setting('archive_sidebar', 
	array(
	'default' 			=> 'right-sidebar',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
	)
);

$wp_customize->add_control('archive_sidebar', 
	array(		
	'label' 	=> __('Archive Sidebar', 'niche-blog'),
	'section' 	=> 'section_sidebar',
	'settings'  => 'archive_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'niche-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'niche-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'niche-blog'),	
		),	
	)
);

// Page Sidebar Option
$wp_customize->add_setting('page_sidebar', 
	array(
	'default' 			=> 'right-sidebar',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
	)
);

$wp_customize->add_control('page_sidebar', 
	array(		
	'label' 	=> __('Page Sidebar', 'niche-blog'),
	'section' 	=> 'section_sidebar',
	'settings'  => 'page_sidebar',
	'type' 		=> 'radio',
	'choices' 	=> array(		
		'left-sidebar' 	=> __( 'Left Sidebar', 'niche-blog'),						
		'right-sidebar' => __( 'Right Sidebar', 'niche-blog'),	
		'no-sidebar' 	=> __( 'No Sidebar', 'niche-blog'),	
		),	
	)
);

// Excerpt Length
$wp_customize->add_section('section_excerpt_length', 
	array(    
	'title'       => __('Excerpt Length', 'niche-blog'),
	'panel'       => 'theme_option_panel'    
	)
);

$wp_customize->add_setting( 'excerpt_length', array(
	'default'           => '28',
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'niche_blog_sanitize_number_range',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'excerpt_length', array(
	'label'       => __( 'Excerpt Length', 'niche-blog' ),
	'description' => __( 'Note: Min 5 & Max 100.', 'niche-blog' ),
	'section'     => 'section_excerpt_length',
	'type'        => 'number',
	'input_attrs' => array( 'min' => 5, 'max' => 100, 'style' => 'width: 55px;' ),
) );

// Social Icons
$wp_customize->add_section( 'social' , array(
	'title'      => esc_html__( 'Social Icons', 'niche-blog' ),
	'priority'   => 80,
	'panel'		 => 'theme_option_panel'
) );

$wp_customize->add_setting( 'social_facebook' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_facebook', array(
	'label'        => esc_html__( 'Facebook', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_facebook',
	'priority'    => 9
) );

$wp_customize->add_setting( 'social_twitter' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_twitter', array(
	'label'        => esc_html__( 'Twitter', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_twitter',
	'priority'    => 9
) );

$wp_customize->add_setting( 'social_instagram' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_instagram', array(
	'label'        => esc_html__( 'Instagram', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_instagram',
	'priority'    => 9
) );

$wp_customize->add_setting( 'social_github' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_github', array(
	'label'        => esc_html__( 'Github', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_github',
	'priority'    => 9
) );

$wp_customize->add_setting( 'social_youtube' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_youtube', array(
	'label'        => esc_html__( 'Youtube', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_youtube',
	'priority'    => 9
) );

$wp_customize->add_setting( 'social_tiktok' , array(
	'default'     => '',
	'transport'   => 'postMessage',
	'sanitize_callback'    => 'esc_url_raw',
) );

$wp_customize->add_control( 'social_tiktok', array(
	'label'        => esc_html__( 'Tiktok', 'niche-blog' ),
	'section'    => 'social',
	'settings'   => 'social_tiktok',
	'priority'    => 9
) );

// Header Settings
$wp_customize->add_section( 'section_header_settings', array(
	'title'      => __( 'Header Settings', 'niche-blog' ),
	'panel'      => 'theme_option_panel',
	'priority'   => 20,
) );

$wp_customize->add_setting( 'header_layout', array(
	'default'           => 'left',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'header_layout', array(
	'label'    => __( 'Header Layout', 'niche-blog' ),
	'section'  => 'section_header_settings',
	'settings' => 'header_layout',
	'type'     => 'select',
	'choices'  => array(
		'left'   => __( 'Left', 'niche-blog' ),
		'center' => __( 'Center', 'niche-blog' ),
		'right'  => __( 'Right', 'niche-blog' ),
	),
) );

// Post Grid Settings
$wp_customize->add_section( 'section_post_grid', array(
	'title'      => __( 'Post Grid', 'niche-blog' ),
	'panel'      => 'theme_option_panel',
	'priority'   => 20,
) );

$wp_customize->add_setting( 'blog_grid_columns', array(
	'default'           => 3,
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'blog_grid_columns', array(
	'label'    => __( 'Grid Columns', 'niche-blog' ),
	'section'  => 'section_post_grid',
	'settings' => 'blog_grid_columns',
	'type'     => 'select',
	'choices'  => array(
		1 => __( '1 Column', 'niche-blog' ),
		2 => __( '2 Columns', 'niche-blog' ),
		3 => __( '3 Columns', 'niche-blog' ),
		4 => __( '4 Columns', 'niche-blog' ),
		5 => __( '5 Columns', 'niche-blog' ),
		6 => __( '6 Columns', 'niche-blog' ),
	),
) );

// Blog Settings
$wp_customize->add_section( 'section_blog_settings', array(
	'title'      => __( 'Blog Settings', 'niche-blog' ),
	'panel'      => 'theme_option_panel',
	'priority'   => 10,
) );

$wp_customize->add_setting( 'hide_cat_links', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'hide_cat_links', array(
	'label'    => __( 'Hide Category Links', 'niche-blog' ),
	'section'  => 'section_blog_settings',
	'settings' => 'hide_cat_links',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'hide_posted_on', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'hide_posted_on', array(
	'label'    => __( 'Hide Posted On Date', 'niche-blog' ),
	'section'  => 'section_blog_settings',
	'settings' => 'hide_posted_on',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'hide_entry_meta', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'hide_entry_meta', array(
	'label'    => __( 'Hide Entry Meta', 'niche-blog' ),
	'section'  => 'section_blog_settings',
	'settings' => 'hide_entry_meta',
	'type'     => 'checkbox',
) );


// Page Layout Settings
$wp_customize->add_section( 'section_page_layout', array(
	'title'      => __( 'Page Layout', 'niche-blog' ),
	'panel'      => 'theme_option_panel',
	'priority'   => 40,
) );

$wp_customize->add_setting( 'page_container_width', array(
	'default'           => 'default',
	'sanitize_callback' => 'niche_blog_sanitize_select',
	'transport'         => 'refresh',
) );

$wp_customize->add_control( 'page_container_width', array(
	'label'    => __( 'Page Container Width', 'niche-blog' ),
	'section'  => 'section_page_layout',
	'settings' => 'page_container_width',
	'type'     => 'select',
	'choices'  => array(
		'default' => __( 'Default', 'niche-blog' ),
		'full'    => __( 'Full Width (100% Screen)', 'niche-blog' ),
		'narrow'  => __( 'Narrow Container', 'niche-blog' ),
	),
) );

// Performance Panel
$wp_customize->add_panel( 'panel_performance', array(
	'title'       => __( 'Performance', 'niche-blog' ),
	'description' => __( 'Improve your site speed with these optimization tools.', 'niche-blog' ),
	'priority'    => 120,
) );

// Section: General
$wp_customize->add_section( 'perf_section_general', array(
	'title' => __( 'General', 'niche-blog' ),
	'panel' => 'panel_performance',
) );

$wp_customize->add_setting( 'perf_disable_emojis', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_disable_emojis', array(
	'label'    => __( 'Disable Emojis Script', 'niche-blog' ),
	'section'  => 'perf_section_general',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'perf_lazy_load', array(
	'default'           => true,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_lazy_load', array(
	'label'    => __( 'Lazy Load Images', 'niche-blog' ),
	'section'  => 'perf_section_general',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'perf_instant_navigation', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_instant_navigation', array(
	'label'    => __( 'Instant Page Navigation', 'niche-blog' ),
	'description' => __( 'Prefetch pages on hover for instant loading.', 'niche-blog' ),
	'section'  => 'perf_section_general',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'perf_reduce_layout_shifts', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_reduce_layout_shifts', array(
	'label'    => __( 'Reduce Layout Shifts', 'niche-blog' ),
	'description' => __( 'Add missing width/height attributes to images.', 'niche-blog' ),
	'section'  => 'perf_section_general',
	'type'     => 'checkbox',
) );

// Section: Caching
$wp_customize->add_section( 'perf_section_caching', array(
	'title' => __( 'Caching', 'niche-blog' ),
	'panel' => 'panel_performance',
) );

$wp_customize->add_setting( 'perf_page_cache', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_page_cache', array(
	'label'       => __( 'Page Caching', 'niche-blog' ),
	'description' => __( 'Experimental: Cache pages to disk.', 'niche-blog' ),
	'section'     => 'perf_section_caching',
	'type'        => 'checkbox',
) );

$wp_customize->add_setting( 'perf_preload_resources', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_preload_resources', array(
	'label'    => __( 'Prioritize Resources', 'niche-blog' ),
	'description' => __( 'Preload critical resources like featured images.', 'niche-blog' ),
	'section'  => 'perf_section_caching',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'perf_clear_cache', array(
	'transport' => 'postMessage',
	'sanitize_callback' => 'niche_blog_sanitize_checkbox', // Dummy callback
) );
$wp_customize->add_control( new Niche_Blog_Customize_Button_Control( $wp_customize, 'perf_clear_cache', array(
	'label'       => __( 'Clear Cache', 'niche-blog' ),
	'description' => __( 'Clear all cached pages.', 'niche-blog' ),
	'section'     => 'perf_section_caching',
	'button_text' => __( 'Clear Cache', 'niche-blog' ),
) ) );

// Section: CSS & JS
$wp_customize->add_section( 'perf_section_css_js', array(
	'title' => __( 'CSS & JS', 'niche-blog' ),
	'panel' => 'panel_performance',
) );

$wp_customize->add_setting( 'perf_minify_html', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_minify_html', array(
	'label'    => __( 'Minify HTML', 'niche-blog' ),
	'section'  => 'perf_section_css_js',
	'type'     => 'checkbox',
) );

$wp_customize->add_setting( 'perf_defer_scripts', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_defer_scripts', array(
	'label'       => __( 'Defer Scripts', 'niche-blog' ),
	'description' => __( 'Add "defer" property to non-essential scripts.', 'niche-blog' ),
	'section'     => 'perf_section_css_js',
	'type'        => 'checkbox',
) );

$wp_customize->add_setting( 'perf_delay_scripts', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_delay_scripts', array(
	'label'       => __( 'Delay Javascript Interaction', 'niche-blog' ),
	'description' => __( 'Delay scripts until user interaction (scroll/click).', 'niche-blog' ),
	'section'     => 'perf_section_css_js',
	'type'        => 'checkbox',
) );

// Section: Fonts
$wp_customize->add_section( 'perf_section_fonts', array(
	'title' => __( 'Fonts', 'niche-blog' ),
	'panel' => 'panel_performance',
) );

$wp_customize->add_setting( 'perf_google_fonts_optimize', array(
	'default'           => false,
	'sanitize_callback' => 'niche_blog_sanitize_checkbox',
) );
$wp_customize->add_control( 'perf_google_fonts_optimize', array(
	'label'    => __( 'Optimize Google Fonts', 'niche-blog' ),
	'description' => __( 'Combine requests and use swap display.', 'niche-blog' ),
	'section'  => 'perf_section_fonts',
	'type'     => 'checkbox',
) );