<?php
/**
 * Niche Blog Theme Customizer
 *
 * @package niche_blog
 */

/**
 * Customizer Button Control.
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	class Niche_Blog_Customize_Button_Control extends WP_Customize_Control {
		public $type = 'button';
		public $button_text = '';

		public function render_content() {
			?>
			<li id="customize-control-<?php echo esc_attr( $this->id ); ?>" class="customize-control customize-control-button">
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<div class="customize-control-content">
					<input type="button" class="button button-secondary" id="<?php echo esc_attr( $this->id ); ?>_btn" value="<?php echo esc_attr( $this->button_text ); ?>">
					<span class="spinner" style="float: none; margin-top: 0;"></span>
					<?php if ( ! empty( $this->description ) ) : ?>
						<span class="description customize-control-description"><?php echo $this->description; ?></span>
					<?php endif; ?>
				</div>
			</li>
			<?php
		}
	}
}

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function niche_blog_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	// Load sanitize functions.
	include get_template_directory() . '/inc/sanitize.php';

	// Load upsell functions.
	// include get_template_directory() . '/inc/customizer/upsell/upsell-section.php';

	// $wp_customize->register_section_type( 'niche_blog_Customize_Upsell_Section' );

	// // Register section.
	// $wp_customize->add_section(
	// 	new niche_blog_Customize_Upsell_Section(
	// 		$wp_customize,
	// 		'theme_upsell',
	// 		array(
	// 			'title'    => esc_html__( 'Niche Blog Extended', 'niche-blog' ),
	// 			'pro_text' => esc_html__( 'Buy Pro', 'niche-blog' ),
	// 			'pro_url'  => 'https://fahimm.com/downloads/niche-blog-pro/',
	// 			'priority' => 10,
	// 		)
	// 	)
	// );

	// Load theme options.
	include get_template_directory() . '/inc/customizer/niche-blog-theme-options.php';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'niche_blog_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-identity-description',
			'render_callback' => 'niche_blog_customize_partial_blogdescription',
		) );
	}
}
add_action( 'customize_register', 'niche_blog_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function niche_blog_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function niche_blog_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function niche_blog_customize_preview_js() {
	wp_enqueue_script( 'niche-blog-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20230101', true );
}
add_action( 'customize_preview_init', 'niche_blog_customize_preview_js' );

/**
 * Customizer control scripts and styles.
 *
 * @since 1.0.0
 */
function niche_blog_customizer_control_scripts() {

	wp_enqueue_style( 'niche-blog-customize-controls', get_template_directory_uri() . '/assets/css/customize-controls.css', '', '1.0.0' );

	wp_enqueue_script( 'niche-blog-customize-controls', get_template_directory_uri() . '/assets/js/customize-controls.js', array( 'customize-controls' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'niche_blog_customizer_control_scripts', 0 );
