/* global niche_blog_l10n */
/**
 * Theme functions file.
 *
 * Contains handlers for navigation and widget area.
 */

(function ($) {
	$(document).ready(function () {
		var masthead, menuToggle, siteNavContain, siteNavigation;

		function initMainNavigation(container) {

			// Add dropdown toggle that displays child menu items.
			var dropdownToggle = $('<button />', { 'class': 'dropdown-toggle', 'aria-expanded': false })
				.append(niche_blog_l10n.icon)
				.append($('<span />', { 'class': 'screen-reader-text', text: niche_blog_l10n.expand }));

			container.find('.menu-item-has-children > a, .page_item_has_children > a').after(dropdownToggle);

			// Set the active submenu dropdown toggle button initial state.
			container.find('.current-menu-ancestor > button')
				.addClass('toggled')
				.attr('aria-expanded', 'true')
				.find('.screen-reader-text')
				.text(niche_blog_l10n.collapse);
			// Set the active submenu initial state.
			container.find('.current-menu-ancestor > .sub-menu').addClass('toggled');

			container.find('.dropdown-toggle').click(function (e) {
				var _this = $(this),
					screenReaderSpan = _this.find('.screen-reader-text');

				e.preventDefault();
				_this.toggleClass('toggled');
				_this.next('.children, .sub-menu').toggleClass('toggled');

				_this.attr('aria-expanded', _this.attr('aria-expanded') === 'false' ? 'true' : 'false');

				screenReaderSpan.text(screenReaderSpan.text() === niche_blog_l10n.expand ? niche_blog_l10n.collapse : niche_blog_l10n.expand);
			});
		}

		initMainNavigation($('.main-navigation'));

		masthead = $('#masthead');
		menuToggle = masthead.find('.primary-menu-toggle');
		siteNavContain = masthead.find('.main-navigation');
		siteNavigation = masthead.find('.main-navigation > div > ul');

		// Enable menuToggle.
		(function () {

			// Return early if menuToggle is missing.
			if (!menuToggle.length) {
				return;
			}

			// Add an initial value for the attribute.
			menuToggle.attr('aria-expanded', 'false');

			menuToggle.on('click.niche_blog', function () {
				siteNavContain.toggleClass('toggled');

				$(this).attr('aria-expanded', siteNavContain.hasClass('toggled'));
			});
		})();

		// Fix sub-menus for touch devices and better focus for hidden submenu items for accessibility.
		(function () {
			if (!siteNavigation.length || !siteNavigation.children().length) {
				return;
			}

			// Toggle `focus` class to allow submenu access on tablets.
			function toggleFocusClassTouchScreen() {
				if ('none' === $('.primary-menu-toggle').css('display')) {

					$(document.body).on('touchstart.niche_blog', function (e) {
						if (!$(e.target).closest('.main-navigation li').length) {
							$('.main-navigation li').removeClass('focus');
						}
					});

					siteNavigation.find('.menu-item-has-children > a, .page_item_has_children > a')
						.on('touchstart.niche_blog', function (e) {
							var el = $(this).parent('li');

							if (!el.hasClass('focus')) {
								e.preventDefault();
								el.toggleClass('focus');
								el.siblings('.focus').removeClass('focus');
							}
						});

				} else {
					siteNavigation.find('.menu-item-has-children > a, .page_item_has_children > a').unbind('touchstart.niche_blog');
				}
			}

			if ('ontouchstart' in window) {
				$(window).on('resize.niche_blog', toggleFocusClassTouchScreen);
				toggleFocusClassTouchScreen();
			}

			siteNavigation.find('a').on('focus.niche_blog blur.niche_blog', function () {
				$(this).parents('.menu-item, .page_item').toggleClass('focus');
			});
		})();
	});
})(jQuery);
