<?php

add_action( 'wp_enqueue_scripts', 'ngo_charity_fundraising_chld_thm_parent_css' );
function ngo_charity_fundraising_chld_thm_parent_css() {

    wp_enqueue_style( 
    	'ngo_charity_fundraising_chld_css', 
    	trailingslashit( get_template_directory_uri() ) . 'style.css', 
    	array( 
    		'bootstrap',
    		'font-awesome-5',
    		'bizberg-main',
    		'bizberg-component',
    		'bizberg-style2',
    		'bizberg-responsive' 
    	) 
    );
    
}

/**
* Change the theme color
*/
add_filter( 'bizberg_theme_color', 'ngo_charity_fundraising_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover_sticky_menu', 'ngo_charity_fundraising_change_theme_color' );
add_filter( 'bizberg_header_button_color_sticky_menu', 'ngo_charity_fundraising_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover_sticky_menu', 'ngo_charity_fundraising_change_theme_color' );
function ngo_charity_fundraising_change_theme_color(){
    return '#e0be53';
}

add_filter( 'bizberg_header_button_border_color', 'ngo_charity_fundraising_btn_border_color' );
add_filter( 'bizberg_header_button_border_color_sticky_menu', 'ngo_charity_fundraising_btn_border_color' );
function ngo_charity_fundraising_btn_border_color(){
    return '#c1970f';
}

/**
* Change the header menu color hover
*/
add_filter( 'bizberg_header_menu_color_hover', 'ngo_charity_fundraising_header_menu_color_hover' );
function ngo_charity_fundraising_header_menu_color_hover(){
    return '#e0be53';
}

/**
* Change the button color of header
*/
add_filter( 'bizberg_header_button_color', 'ngo_charity_fundraising_header_button_color' );
function ngo_charity_fundraising_header_button_color(){
    return '#e0be53';
}

/**
* Change the button hover color of header
*/
add_filter( 'bizberg_header_button_color_hover', 'ngo_charity_fundraising_header_button_color_hover' );
function ngo_charity_fundraising_header_button_color_hover(){
    return '#e0be53';
}

add_filter( 'bizberg_slider_title_box_highlight_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_slider_arrow_background_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_slider_dot_active_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_slider_gradient_primary_color', function(){
    return 'rgba(224,190,83,0.65)';
});

add_filter( 'bizberg_read_more_background_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_read_more_background_color_2', function(){
    return '#e0be53';
});

add_filter( 'bizberg_link_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_link_color_hover', function(){
    return '#e0be53';
});

add_filter( 'bizberg_blog_listing_pagination_active_hover_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_sidebar_widget_link_color_hover', function(){
    return '#e0be53';
});

add_filter( 'bizberg_sidebar_widget_title_color', function(){
    return '#e0be53';
});

add_filter( 'bizberg_footer_social_icon_background', function(){
    return '#e0be53';
});

add_filter( 'bizberg_footer_social_icon_color', function(){
    return '#fff';
});

add_filter( 'bizberg_getting_started_screenshot', function(){
    return true;
});

add_filter( 'bizberg_banner_title', 'ngo_charity_fundraising_banner_title' );
function ngo_charity_fundraising_banner_title(){
    return current_user_can( 'edit_theme_options' ) ? esc_html__( 'Martin Peterson' , 'ngo-charity-fundraising' ) : '';
}

add_action( 'after_setup_theme', 'ngo_charity_fundraising_setup_theme' );
function ngo_charity_fundraising_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
}