<?php

/**
 * Title: Accordion
 * Slug: nexara/accordion
 * Categories: featured
 * Keywords: Accordion
 */
?>
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|80","bottom":"var:preset|spacing|100","right":"20px","left":"20px"},"blockGap":"0","margin":{"top":"0","bottom":"0"}}},"className":"Nexara-Accordion","layout":{"type":"default"}} -->
<div class="wp-block-group alignfull Nexara-Accordion" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--80);padding-right:20px;padding-bottom:var(--wp--preset--spacing--100);padding-left:20px"><!-- wp:group {"style":{"spacing":{"padding":{"right":"0","left":"0"}}},"layout":{"type":"constrained","contentSize":"980px"}} -->
    <div class="wp-block-group" style="padding-right:0;padding-left:0"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|55"}}}} -->
        <h2 class="wp-block-heading has-text-align-center" style="padding-bottom:var(--wp--preset--spacing--55)"><?php esc_html_e('Frequently asked questions', 'nexara'); ?></h2>
        <!-- /wp:heading -->

        <!-- wp:group {"align":"wide","style":{"border":{"width":"1px","color":"secondary","radius":"20px"},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"layout":{"type":"default"}} -->
        <div class="wp-block-group alignwide has-border-color" style="border-color:secondary;border-width:1px;border-radius:20px;margin-bottom:var(--wp--preset--spacing--20)"><!-- wp:details {"align":"wide","style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"blockGap":"0"}},"textColor":"secondary","fontSize":"medium"} -->
            <details class="wp-block-details alignwide has-secondary-color has-text-color has-medium-font-size" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:700">
                <summary><?php esc_html_e('What types of software development services do you offer?', 'nexara'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.9"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"x-small"} -->
                <p class="has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--20);font-style:normal;font-weight:500;line-height:1.9"><?php esc_html_e("We offer a wide range of software development services, including web and mobile application development, custom software solutions, system integration, and software maintenance. Our expertise spans various technologies, frameworks, and industries, ensuring we can meet your unique requirements.", 'nexara'); ?></p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"align":"wide","style":{"border":{"width":"1px","color":"secondary","radius":"20px"},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"layout":{"type":"default"}} -->
        <div class="wp-block-group alignwide has-border-color" style="border-color:secondary;border-width:1px;border-radius:20px;margin-bottom:var(--wp--preset--spacing--20)"><!-- wp:details {"align":"wide","style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"blockGap":"0"}},"textColor":"secondary","fontSize":"medium"} -->
            <details class="wp-block-details alignwide has-secondary-color has-text-color has-medium-font-size" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:700">
                <summary><?php esc_html_e('How do you ensure the quality of your software?', 'nexara'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.9"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"x-small"} -->
                <p class="has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--20);font-style:normal;font-weight:500;line-height:1.9"><?php esc_html_e('Features', 'nexara'); ?><?php esc_html_e("We have a rigorous quality assurance process that includes automated and manual testing, code reviews, and continuous integration. Our development team follows best practices to ensure that our software is reliable, secure, and performs at its best.", 'nexara'); ?></p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"align":"wide","style":{"border":{"width":"1px","color":"secondary","radius":"20px"},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"layout":{"type":"default"}} -->
        <div class="wp-block-group alignwide has-border-color" style="border-color:secondary;border-width:1px;border-radius:20px;margin-bottom:var(--wp--preset--spacing--20)"><!-- wp:details {"align":"wide","style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"blockGap":"0"}},"textColor":"secondary","fontSize":"medium"} -->
            <details class="wp-block-details alignwide has-secondary-color has-text-color has-medium-font-size" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:700">
                <summary><?php esc_html_e('What is your typical project timeline?', 'nexara'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.9"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"x-small"} -->
                <p class="has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--20);font-style:normal;font-weight:500;line-height:1.9"><?php esc_html_e("The timeline for a project depends on its scope and complexity. We work closely with our clients to define clear milestones and keep them updated throughout the development process. While smaller projects may be completed in a few weeks, larger projects can take several months or longer. We always aim to deliver on time and within budget.", 'nexara'); ?></p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"align":"wide","style":{"border":{"width":"1px","color":"secondary","radius":"20px"},"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"layout":{"type":"default"}} -->
        <div class="wp-block-group alignwide has-border-color" style="border-color:secondary;border-width:1px;border-radius:20px;margin-bottom:var(--wp--preset--spacing--20)"><!-- wp:details {"align":"wide","style":{"typography":{"fontStyle":"normal","fontWeight":"700"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"blockGap":"0"}},"textColor":"secondary","fontSize":"medium"} -->
            <details class="wp-block-details alignwide has-secondary-color has-text-color has-medium-font-size" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);font-style:normal;font-weight:700">
                <summary><?php esc_html_e('How do you handle project communication and updates?', 'nexara'); ?></summary><!-- wp:paragraph {"placeholder":"Type / to add a hidden block","style":{"typography":{"fontStyle":"normal","fontWeight":"500","lineHeight":"1.9"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"x-small"} -->
                <p class="has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--20);font-style:normal;font-weight:500;line-height:1.9"><?php esc_html_e("Communication is key to a successful project. We use collaborative tools to maintain open lines of communication with our clients, providing regular updates and progress reports. Our project managers are readily available to address any questions or concerns, ensuring you always know what's happening.", 'nexara'); ?></p>
                <!-- /wp:paragraph -->
            </details>
            <!-- /wp:details -->
        </div>
        <!-- /wp:group -->
    </div>
    <!-- /wp:group -->
</div>
<!-- /wp:group -->


