<?php
/**
 * Title: Destinations card, 4 columns
 * Slug: nexal/destinations-card-4-col
 * Categories: features, nexal, call-to-action, gallery, about
 */
?>
<!-- wp:group {"metadata":{"name":"Destinations card, 4 columns"},"ploverBlockID":"b90e5ecd-7ede-41a3-901c-69799d37183a","className":"is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|x-large","bottom":"var:preset|spacing|x-large"}},"elements":{"link":{"color":{"text":"var:preset|color|neutral-800"}},"heading":{"color":{"text":"var:preset|color|neutral-950"}}}},"backgroundColor":"neutral-0","textColor":"neutral-800","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-default has-neutral-800-color has-neutral-0-background-color has-text-color has-background has-link-color"
    style="padding-top:var(--wp--preset--spacing--x-large);padding-bottom:var(--wp--preset--spacing--x-large)">
    <!-- wp:columns {"verticalAlignment":"center","ploverBlockID":"39d19181-61ff-4a2a-90f7-45ed2eb752a5","align":"wide"} -->
    <div class="wp-block-columns alignwide are-vertically-aligned-center">
        <!-- wp:column {"verticalAlignment":"center","ploverBlockID":"92b987cb-4ef7-4c05-9ee4-57b4d65497dd","layout":{"type":"constrained","justifyContent":"left"}} -->
        <div class="wp-block-column is-vertically-aligned-center">
            <!-- wp:heading {"ploverBlockID":"e9542a99-6ac5-46ed-bc3d-0b9fd7005112"} -->
            <h2 class="wp-block-heading"><?php esc_html_e('Choose Your Next Destinations', 'nexal') ?></h2>
            <!-- /wp:heading -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"verticalAlignment":"center","ploverBlockID":"6c1c6316-6310-4dfe-8896-2c6c584e9d72","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}}} -->
        <div class="wp-block-column is-vertically-aligned-center">
            <!-- wp:group {"ploverBlockID":"832d827c-9c58-4f4f-85f7-d3fe12675d61","style":{"spacing":{"blockGap":"var:preset|spacing|2-x-small"},"typography":{"fontStyle":"normal","fontWeight":"600"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
            <div class="wp-block-group" style="font-style:normal;font-weight:600">
                <!-- wp:paragraph {"ploverBlockID":"e98a238d-dd1f-41e0-8bbd-1e0a8f78c877","style":{"elements":{"link":{"color":{"text":"var:preset|color|primary-color"}}}},"textColor":"primary-color"} -->
                <p class="has-primary-color-color has-text-color has-link-color">1000+</p>
                <!-- /wp:paragraph -->

                <!-- wp:paragraph {"ploverBlockID":"9489238c-2d94-49c6-8d08-cfa94c36d303"} -->
                <p><?php esc_html_e('destinations', 'nexal') ?></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->

            <!-- wp:paragraph {"ploverBlockID":"1dd999be-16fc-4c37-bfd4-9e1c3a44426c","style":{"border":{"left":{"color":"var:preset|color|primary-color","width":"4px"}},"spacing":{"padding":{"left":"var:preset|spacing|small"}}}} -->
            <p style="border-left-color:var(--wp--preset--color--primary-color);border-left-width:4px;padding-left:var(--wp--preset--spacing--small)"><?php esc_html_e('From the serene beaches of the Maldives to the bustling streets of Tokyo, each location presents unique cultural, historical, and natural attractions.', 'nexal') ?></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->

    <!-- wp:spacer {"height":"48px","ploverBlockID":"5cf56bdb-5883-48e2-a0fc-a68acc1a138a"} -->
    <div style="height:48px" aria-hidden="true" class="wp-block-spacer"></div>
    <!-- /wp:spacer -->

    <!-- wp:columns {"ploverBlockID":"8ac006a0-ad2f-4dea-a361-29f5bc34fe01","align":"wide"} -->
    <div class="wp-block-columns alignwide"><!-- wp:column {"ploverBlockID":"6eba81a1-c594-4754-ab4f-1888426472f2"} -->
        <div class="wp-block-column">
            <!-- wp:cover {"url":"<?php the_nexal_asset_url('images/destination-01.jpg') ?>","isUserOverlayColor":true,"minHeight":430,"minHeightUnit":"px","customGradient":"linear-gradient(0deg,rgb(21,32,58) 4%,rgba(79,156,247,0.36) 78%)","contentPosition":"bottom center","ploverBlockID":"a004ab3a-5155-4536-8e3d-70af2c29758d","className":"is-style-default","style":{"border":{"radius":"8px"},"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"right":"var:preset|spacing|2-x-small","left":"var:preset|spacing|2-x-small","top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}},"color":{"text":"#fffffe"}},"layout":{"type":"constrained"}} -->
            <div class="wp-block-cover has-custom-content-position is-position-bottom-center is-style-default has-text-color has-link-color"
                style="border-radius:8px;color:#fffffe;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--2-x-small);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--2-x-small);min-height:430px">
                <span aria-hidden="true"
                    class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient"
                    style="background:linear-gradient(0deg,rgb(21,32,58) 4%,rgba(79,156,247,0.36) 78%)"></span>
                <img class="wp-block-cover__image-background" alt=""
                    src="<?php the_nexal_asset_url('images/destination-01.jpg') ?>" data-object-fit="cover" />
                <div class="wp-block-cover__inner-container">
                    <!-- wp:group {"ploverBlockID":"349e6a75-0f1e-4c0a-8b1a-aecf6c0ac60e","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"default"}} -->
                    <div class="wp-block-group">
                        <!-- wp:heading {"level":3,"ploverBlockID":"1ea45cd7-ad5c-4e83-b324-f979bb3994d2","style":{"elements":{"link":{"color":{"text":"var:preset|color|inherit"}}}},"textColor":"inherit","fontSize":"3-x-large"} -->
                        <h3 class="wp-block-heading has-inherit-color has-text-color has-link-color has-3-x-large-font-size"><?php esc_html_e('Greece', 'nexal') ?></h3>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph {"ploverBlockID":"7403fadf-314a-40df-a540-435ba966b6fe","fontSize":"small"} -->
                        <p class="has-small-font-size"><?php esc_html_e('A country steeped in history and natural beauty, offers a captivating blend of ancient ruins and vibrant culture.', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"1adf391c-1be1-4f39-8924-bc76ca54624a"} -->
                        <p><strong>$299.00 USD</strong></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:buttons {"ploverBlockID":"53453d72-bf51-4304-b7fc-9d7241141c5a"} -->
                        <div class="wp-block-buttons">
                            <!-- wp:button {"ploverBlockID":"28f8fbbb-cc4d-4a0b-8f01-abb1f0ee0509","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"left":"0.85rem","right":"0.85rem","top":"0.75rem","bottom":"0.75rem"}},"color":{"text":"#fffffe","background":"#ffffff00"},"typography":{"textTransform":"uppercase"}},"fontSize":"x-small"} -->
                            <div class="wp-block-button has-custom-font-size is-style-outline has-x-small-font-size"
                                style="text-transform:uppercase">
                                <a
                                    class="wp-block-button__link has-text-color has-background has-link-color wp-element-button"
                                    style="color:#fffffe;background-color:#ffffff00;padding-top:0.75rem;padding-right:0.85rem;padding-bottom:0.75rem;padding-left:0.85rem"
                                ><?php esc_html_e('Book a travel', 'nexal') ?></a>
                            </div>
                            <!-- /wp:button -->
                        </div>
                        <!-- /wp:buttons -->
                    </div>
                    <!-- /wp:group -->
                </div>
            </div>
            <!-- /wp:cover -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"05de56d0-da6f-4fab-8924-59ebfa4e9920"} -->
        <div class="wp-block-column">
            <!-- wp:cover {"url":"<?php the_nexal_asset_url('images/destination-02.jpg') ?>","isUserOverlayColor":true,"minHeight":430,"minHeightUnit":"px","customGradient":"linear-gradient(0deg,rgb(21,32,58) 4%,rgba(51,43,208,0.27) 78%)","contentPosition":"bottom center","ploverBlockID":"d8983a12-1a86-41d6-95f7-8be0c941501a","className":"is-style-default","style":{"border":{"radius":"8px"},"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"right":"var:preset|spacing|2-x-small","left":"var:preset|spacing|2-x-small","top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}},"color":{"text":"#fffffe"}},"layout":{"type":"constrained"}} -->
            <div class="wp-block-cover has-custom-content-position is-position-bottom-center is-style-default has-text-color has-link-color"
                style="border-radius:8px;color:#fffffe;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--2-x-small);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--2-x-small);min-height:430px">
                <span aria-hidden="true"
                    class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient"
                    style="background:linear-gradient(0deg,rgb(21,32,58) 4%,rgba(51,43,208,0.27) 78%)"></span>
                <img class="wp-block-cover__image-background" alt=""
                    src="<?php the_nexal_asset_url('images/destination-02.jpg') ?>" data-object-fit="cover" />
                <div class="wp-block-cover__inner-container">
                    <!-- wp:group {"ploverBlockID":"a2976dd6-5450-472d-992e-c034078be1ad","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"default"}} -->
                    <div class="wp-block-group">
                        <!-- wp:heading {"level":3,"ploverBlockID":"f55ebe4b-61a7-4eb4-bf9b-8694639826f5","style":{"elements":{"link":{"color":{"text":"var:preset|color|inherit"}}}},"textColor":"inherit","fontSize":"3-x-large"} -->
                        <h3 class="wp-block-heading has-inherit-color has-text-color has-link-color has-3-x-large-font-size"><?php esc_html_e('French', 'nexal') ?></h3>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph {"ploverBlockID":"95888b3f-2650-4ecc-986d-232d11129d87","fontSize":"small"} -->
                        <p class="has-small-font-size"><?php esc_html_e('A country steeped in history and natural beauty, offers a captivating blend of ancient ruins and vibrant culture.', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"eba07bb0-bf21-4e67-aa6a-01d24e9eba86"} -->
                        <p><strong>$259.00 USD</strong></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:buttons {"ploverBlockID":"a3911662-5de0-46e1-82a8-97369b610535"} -->
                        <div class="wp-block-buttons">
                            <!-- wp:button {"ploverBlockID":"494348ac-de69-4aa1-a0dd-14be5d754862","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"left":"0.85rem","right":"0.85rem","top":"0.75rem","bottom":"0.75rem"}},"color":{"text":"#fffffe","background":"#ffffff00"},"typography":{"textTransform":"uppercase"}},"fontSize":"x-small"} -->
                            <div class="wp-block-button has-custom-font-size is-style-outline has-x-small-font-size"
                                style="text-transform:uppercase">
                                <a
                                    class="wp-block-button__link has-text-color has-background has-link-color wp-element-button"
                                    style="color:#fffffe;background-color:#ffffff00;padding-top:0.75rem;padding-right:0.85rem;padding-bottom:0.75rem;padding-left:0.85rem"
                                ><?php esc_html_e('Book a travel', 'nexal') ?></a>
                            </div>
                            <!-- /wp:button -->
                        </div>
                        <!-- /wp:buttons -->
                    </div>
                    <!-- /wp:group -->
                </div>
            </div>
            <!-- /wp:cover -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"4d4cea06-72aa-4215-9231-dce9e5f7e26e"} -->
        <div class="wp-block-column">
            <!-- wp:cover {"url":"<?php the_nexal_asset_url('images/destination-03.jpg') ?>","isUserOverlayColor":true,"minHeight":430,"minHeightUnit":"px","customGradient":"linear-gradient(0deg,rgb(21,32,58) 4%,rgba(240,40,135,0.19) 78%)","contentPosition":"bottom center","ploverBlockID":"0d606012-cfc3-4657-a37d-b9fea88e7732","className":"is-style-default","style":{"border":{"radius":"8px"},"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"right":"var:preset|spacing|2-x-small","left":"var:preset|spacing|2-x-small","top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}},"color":{"text":"#fffffe"}},"layout":{"type":"constrained"}} -->
            <div class="wp-block-cover has-custom-content-position is-position-bottom-center is-style-default has-text-color has-link-color"
                style="border-radius:8px;color:#fffffe;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--2-x-small);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--2-x-small);min-height:430px">
                <span aria-hidden="true"
                    class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient"
                    style="background:linear-gradient(0deg,rgb(21,32,58) 4%,rgba(240,40,135,0.19) 78%)"></span>
                <img class="wp-block-cover__image-background" alt=""
                    src="<?php the_nexal_asset_url('images/destination-03.jpg') ?>" data-object-fit="cover" />
                <div class="wp-block-cover__inner-container">
                    <!-- wp:group {"ploverBlockID":"09b76c7e-284b-47fb-9953-d095fcadf632","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"default"}} -->
                    <div class="wp-block-group">
                        <!-- wp:heading {"level":3,"ploverBlockID":"9bb90823-34fe-4df3-8825-127fb1f78fcf","style":{"elements":{"link":{"color":{"text":"var:preset|color|inherit"}}}},"textColor":"inherit","fontSize":"3-x-large"} -->
                        <h3 class="wp-block-heading has-inherit-color has-text-color has-link-color has-3-x-large-font-size"><?php esc_html_e('Japan', 'nexal') ?></h3>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph {"ploverBlockID":"01d1b587-788b-4c5f-aa60-8e8b965bf546","fontSize":"small"} -->
                        <p class="has-small-font-size"><?php esc_html_e('A country steeped in history and natural beauty, offers a captivating blend of ancient ruins and vibrant culture.', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"e30760e1-272f-4718-9354-e6f47ae6d71d"} -->
                        <p><strong>$199.00 USD</strong></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:buttons {"ploverBlockID":"30c943db-9a85-46f0-be7e-3d111ab833d2"} -->
                        <div class="wp-block-buttons">
                            <!-- wp:button {"ploverBlockID":"c52d1686-ec82-4363-8a40-0ebc1b2dcbf6","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"left":"0.85rem","right":"0.85rem","top":"0.75rem","bottom":"0.75rem"}},"color":{"text":"#fffffe","background":"#ffffff00"},"typography":{"textTransform":"uppercase"}},"fontSize":"x-small"} -->
                            <div class="wp-block-button has-custom-font-size is-style-outline has-x-small-font-size"
                                style="text-transform:uppercase">
                                <a
                                    class="wp-block-button__link has-text-color has-background has-link-color wp-element-button"
                                    style="color:#fffffe;background-color:#ffffff00;padding-top:0.75rem;padding-right:0.85rem;padding-bottom:0.75rem;padding-left:0.85rem"
                                ><?php esc_html_e('Book a travel', 'nexal') ?></a>
                            </div>
                            <!-- /wp:button -->
                        </div>
                        <!-- /wp:buttons -->
                    </div>
                    <!-- /wp:group -->
                </div>
            </div>
            <!-- /wp:cover -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"1c55fda0-c08c-4723-a2e5-06b7dde3aed4"} -->
        <div class="wp-block-column">
            <!-- wp:cover {"url":"<?php the_nexal_asset_url('images/destination-04.jpg') ?>","isUserOverlayColor":true,"minHeight":430,"minHeightUnit":"px","customGradient":"linear-gradient(0deg,rgb(21,32,58) 4%,rgba(23,159,122,0.28) 78%)","contentPosition":"bottom center","ploverBlockID":"a3a61e3d-d1d8-468c-98fd-9dd45b3fdc6c","className":"is-style-default","style":{"border":{"radius":"8px"},"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"right":"var:preset|spacing|2-x-small","left":"var:preset|spacing|2-x-small","top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium"}},"color":{"text":"#fffffe"}},"layout":{"type":"constrained"}} -->
            <div class="wp-block-cover has-custom-content-position is-position-bottom-center is-style-default has-text-color has-link-color"
                style="border-radius:8px;color:#fffffe;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--2-x-small);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--2-x-small);min-height:430px">
                <span aria-hidden="true"
                    class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient"
                    style="background:linear-gradient(0deg,rgb(21,32,58) 4%,rgba(23,159,122,0.28) 78%)"></span>
                <img class="wp-block-cover__image-background" alt=""
                    src="<?php the_nexal_asset_url('images/destination-04.jpg') ?>" data-object-fit="cover" />
                <div class="wp-block-cover__inner-container">
                    <!-- wp:group {"ploverBlockID":"c477c19d-ad9e-4a8c-8d9e-0bd16bd1fe4d","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"default"}} -->
                    <div class="wp-block-group">
                        <!-- wp:heading {"level":3,"ploverBlockID":"33b37c9f-61b6-44b1-b6fe-3ab3d65b5df1","style":{"elements":{"link":{"color":{"text":"var:preset|color|inherit"}}}},"textColor":"inherit","fontSize":"3-x-large"} -->
                        <h3 class="wp-block-heading has-inherit-color has-text-color has-link-color has-3-x-large-font-size"><?php esc_html_e('Maldives', 'nexal') ?></h3>
                        <!-- /wp:heading -->

                        <!-- wp:paragraph {"ploverBlockID":"c2ada2b1-64da-4be3-9d01-fcf65b184fbd","fontSize":"small"} -->
                        <p class="has-small-font-size"><?php esc_html_e('A country steeped in history and natural beauty, offers a captivating blend of ancient ruins and vibrant culture.', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"e54d3661-74e1-43f9-986f-4f267e90e05f"} -->
                        <p><strong>$499.00 USD</strong></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:buttons {"ploverBlockID":"e413f5d7-e710-4421-a3cb-08261e5bcb93"} -->
                        <div class="wp-block-buttons">
                            <!-- wp:button {"ploverBlockID":"b28cff9a-7148-471c-b01f-ddb452bd765d","className":"is-style-outline","style":{"elements":{"link":{"color":{"text":"#fffffe"}}},"spacing":{"padding":{"left":"0.85rem","right":"0.85rem","top":"0.75rem","bottom":"0.75rem"}},"color":{"text":"#fffffe","background":"#ffffff00"},"typography":{"textTransform":"uppercase"}},"fontSize":"x-small"} -->
                            <div class="wp-block-button has-custom-font-size is-style-outline has-x-small-font-size"
                                style="text-transform:uppercase">
                                <a
                                    class="wp-block-button__link has-text-color has-background has-link-color wp-element-button"
                                    style="color:#fffffe;background-color:#ffffff00;padding-top:0.75rem;padding-right:0.85rem;padding-bottom:0.75rem;padding-left:0.85rem"
                                ><?php esc_html_e('Book a travel', 'nexal') ?></a>
                            </div>
                            <!-- /wp:button -->
                        </div>
                        <!-- /wp:buttons -->
                    </div>
                    <!-- /wp:group -->
                </div>
            </div>
            <!-- /wp:cover -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->