<?php
/**
 * Title: Dark testimonials, 2 columns
 * Slug: nexal/dark-testimonials-2-col
 * Categories: testimonials, nexal, team, about
 */
?>
<!-- wp:group {"metadata":{"name":"Dark testimonials, 2 columns"},"ploverBlockID":"69680246-a168-4924-b6ed-890753cc111e","className":"is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|2-x-large","bottom":"var:preset|spacing|2-x-large"}},"elements":{"link":{"color":{"text":"var:preset|color|neutral-800"}},"heading":{"color":{"text":"var:preset|color|neutral-950"}}}},"backgroundColor":"neutral-0","textColor":"neutral-800","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-dark has-neutral-800-color has-neutral-0-background-color has-text-color has-background has-link-color"
    style="padding-top:var(--wp--preset--spacing--2-x-large);padding-bottom:var(--wp--preset--spacing--2-x-large)">
    <!-- wp:columns {"ploverBlockID":"c1b951f0-bd39-416e-a552-1909f98971e0","align":"wide"} -->
    <div class="wp-block-columns alignwide"><!-- wp:column {"ploverBlockID":"316efa7d-b082-472d-88e6-5e02c18c75c6"} -->
        <div class="wp-block-column">
            <!-- wp:group {"metadata":{"name":"Heading and description"},"ploverBlockID":"4bb18ea1-39a7-4e71-99c6-1b36486593cb","align":"wide","layout":{"type":"constrained","justifyContent":"left"}} -->
            <div class="wp-block-group alignwide">
                <!-- wp:heading {"textAlign":"left","ploverBlockID":"92d9f5d3-5f10-4367-90b5-ff494d0baaa0","align":"wide","style":{"typography":{"textTransform":"none"}}} -->
                <h2 class="wp-block-heading alignwide has-text-align-left" style="text-transform:none"><?php esc_html_e('What Our Customers Says', 'nexal') ?></h2>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"left","ploverBlockID":"88e5aca6-9e90-4327-8b3a-cdc97ec61a47"} -->
                <p class="has-text-align-left"><?php esc_html_e("Don't just take our word for it. Listen to what our customers have to say.", 'nexal') ?></p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"ploverBlockID":"e0cca6a6-37e0-49bd-8915-7375b34792e6","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200","layout":{"type":"default"}} -->
            <div class="wp-block-group has-neutral-200-background-color has-background"
                style="border-radius:6px;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium)">
                <!-- wp:paragraph {"ploverBlockID":"8b2ba7fe-41fa-4409-adf2-ee3dacc390f1"} -->
                <p><?php esc_html_e("I couldn't be happier with the experience! From the moment I inquired about their services, the team was incredibly responsive and attentive to my needs. The itinerary was perfectly tailored to include breathtaking landscapes and hidden gems, and our guide was not only knowledgeable but also passionate about photography. The professional photographer captured stunning moments throughout our journey, providing me with high-quality images that I will cherish forever.", 'nexal') ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:group {"ploverBlockID":"1fc7fcab-516f-4f76-8e50-b5db5c34028d","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                <div class="wp-block-group">
                    <!-- wp:image {"lightbox":{"enabled":false},"width":"68px","height":"68px","scale":"cover","sizeSlug":"medium","linkDestination":"none","ploverBlockID":"8881184c-2252-4f87-b738-9d4dc5fe7c71","align":"center","style":{"border":{"radius":"100px"}}} -->
                    <figure class="wp-block-image aligncenter size-medium is-resized has-custom-border"><img
                            src="<?php the_nexal_asset_url('images/portrait-01.jpg') ?>" alt=""
                            style="border-radius:100px;object-fit:cover;width:68px;height:68px" /></figure>
                    <!-- /wp:image -->

                    <!-- wp:group {"ploverBlockID":"454f7546-8479-444e-8df5-0d9a1428cc05","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group">
                        <!-- wp:paragraph {"ploverBlockID":"1f2dac8d-c338-4884-9b21-413885ddd15e","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
                        <p style="font-style:normal;font-weight:600"><?php esc_html_e('Harry Read', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"a1fff5b5-430d-475e-a201-b7887258c704","style":{"elements":{"link":{"color":{"text":"var:preset|color|primary-color"}}}},"textColor":"primary-color","fontSize":"small"} -->
                        <p class="has-primary-color-color has-text-color has-link-color has-small-font-size"><?php esc_html_e('Japan Traveler', 'nexal') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:group -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"d9a11259-c0b4-4274-ae10-e4897c05a80a"} -->
        <div class="wp-block-column">
            <!-- wp:group {"ploverBlockID":"b4f31dc1-83f7-4027-8535-6439c7ffa3e3","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200","layout":{"type":"default"}} -->
            <div class="wp-block-group has-neutral-200-background-color has-background"
                style="border-radius:6px;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium)">
                <!-- wp:paragraph {"ploverBlockID":"3e408932-03a1-4d91-b951-9fadffc96381"} -->
                <p><?php esc_html_e("Their travel package included not only amazing destinations but also expert photography workshops led by talented professionals. I learned so much about composition and lighting while exploring picturesque locations. If you're a photography enthusiast looking to enhance your skills while traveling, I highly recommend their service.", 'nexal') ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:group {"ploverBlockID":"81b0e6c7-faa5-4b3a-a41a-0fdecaee922a","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                <div class="wp-block-group">
                    <!-- wp:image {"lightbox":{"enabled":false},"width":"68px","height":"68px","scale":"cover","sizeSlug":"full","linkDestination":"none","ploverBlockID":"d73d741e-d896-48c6-b02f-d8da519b1bc7","align":"center","style":{"border":{"radius":"100px"}}} -->
                    <figure class="wp-block-image aligncenter size-full is-resized has-custom-border"><img
                            src="<?php the_nexal_asset_url('images/portrait-02.jpg') ?>" alt=""
                            style="border-radius:100px;object-fit:cover;width:68px;height:68px" />
                    </figure>
                    <!-- /wp:image -->

                    <!-- wp:group {"ploverBlockID":"8b4df688-20dc-4314-9c63-352a7c955e9f","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group">
                        <!-- wp:paragraph {"ploverBlockID":"05fa0f7f-915b-49dc-84dd-24c471bdeaf8","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
                        <p style="font-style:normal;font-weight:600"><?php esc_html_e('Lois Pope', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"2b9448c0-e44f-42c2-9592-82baa9cc9e0f","style":{"elements":{"link":{"color":{"text":"var:preset|color|primary-color"}}}},"textColor":"primary-color","fontSize":"small"} -->
                        <p class="has-primary-color-color has-text-color has-link-color has-small-font-size"><?php esc_html_e('Spanish Traveler', 'nexal') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:group -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"ploverBlockID":"4f477676-b0af-4cd1-8e76-b78c6348cb4e","style":{"spacing":{"padding":{"top":"var:preset|spacing|medium","bottom":"var:preset|spacing|medium","left":"var:preset|spacing|medium","right":"var:preset|spacing|medium"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200","layout":{"type":"default"}} -->
            <div class="wp-block-group has-neutral-200-background-color has-background"
                style="border-radius:6px;padding-top:var(--wp--preset--spacing--medium);padding-right:var(--wp--preset--spacing--medium);padding-bottom:var(--wp--preset--spacing--medium);padding-left:var(--wp--preset--spacing--medium)">
                <!-- wp:paragraph {"ploverBlockID":"fb7d7875-82bd-48ab-ac92-3f52e3116bdc"} -->
                <p><?php esc_html_e('I had an incredible experience during my recent trip to the mountains. Their service was top-notch from start to finish. The travel arrangements were seamless, and the itinerary was packed with breathtaking views and unique experiences. The photographer was not only skilled but also made the whole group feel comfortable, resulting in natural and candid shots.', 'nexal') ?></p>
                <!-- /wp:paragraph -->

                <!-- wp:group {"ploverBlockID":"93e70d84-1f52-4995-837b-7308b6247fec","style":{"spacing":{"blockGap":"var:preset|spacing|x-small"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                <div class="wp-block-group">
                    <!-- wp:image {"lightbox":{"enabled":false},"width":"68px","height":"68px","scale":"cover","sizeSlug":"full","linkDestination":"none","ploverBlockID":"79841ca0-05cd-4747-a91a-203f79c16798","align":"center","style":{"border":{"radius":"100px"}}} -->
                    <figure class="wp-block-image aligncenter size-full is-resized has-custom-border"><img
                            src="<?php the_nexal_asset_url('images/portrait-03.jpg') ?>" alt=""
                            style="border-radius:100px;object-fit:cover;width:68px;height:68px" />
                    </figure>
                    <!-- /wp:image -->

                    <!-- wp:group {"ploverBlockID":"02df3ba6-d532-4d8d-9bd6-91f3d291c5ef","style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group">
                        <!-- wp:paragraph {"ploverBlockID":"45c11215-6774-4f9f-a5ee-8393ebf08300","style":{"typography":{"fontStyle":"normal","fontWeight":"600"}}} -->
                        <p style="font-style:normal;font-weight:600"><?php esc_html_e('Walter Trivett', 'nexal') ?></p>
                        <!-- /wp:paragraph -->

                        <!-- wp:paragraph {"ploverBlockID":"2f75a694-7910-44c7-9067-e565db5da6b2","style":{"elements":{"link":{"color":{"text":"var:preset|color|primary-color"}}}},"textColor":"primary-color","fontSize":"small"} -->
                        <p class="has-primary-color-color has-text-color has-link-color has-small-font-size"><?php esc_html_e('Thailand Traveler', 'nexal') ?></p>
                        <!-- /wp:paragraph -->
                    </div>
                    <!-- /wp:group -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->
