<?php
/**
 * Title: Dark features with icon, 4 columns
 * Slug: nexal/dark-features-with-icon-4-col
 * Categories: features, nexal
 */
?>
<!-- wp:group {"metadata":{"name":"Dark features with icon, 4 columns"},"ploverBlockID":"daee8a54-daa0-4ed2-a36c-14ff53003c55","className":"is-style-default","style":{"spacing":{"padding":{"top":"var:preset|spacing|x-large","bottom":"var:preset|spacing|x-large"},"blockGap":"var:preset|spacing|large"},"elements":{"link":{"color":{"text":"var:preset|color|neutral-800"}},"heading":{"color":{"text":"var:preset|color|neutral-950"}}}},"backgroundColor":"neutral-0","textColor":"neutral-800","layout":{"type":"constrained"}} -->
<div class="wp-block-group is-style-dark has-neutral-800-color has-neutral-0-background-color has-text-color has-background has-link-color"
    style="padding-top:var(--wp--preset--spacing--x-large);padding-bottom:var(--wp--preset--spacing--x-large)">
    <!-- wp:group {"metadata":{"name":"Heading and description"},"ploverBlockID":"f832a3ed-2ffd-4188-9a41-dcb033d95896","align":"wide","layout":{"type":"constrained"}} -->
    <div class="wp-block-group alignwide">
        <!-- wp:heading {"textAlign":"center","ploverBlockID":"7df0c26e-9541-417a-bd69-d7f1bd47b955","align":"wide","style":{"typography":{"textTransform":"none"}}} -->
        <h2 class="wp-block-heading alignwide has-text-align-center" style="text-transform:none"><?php esc_html_e('We are Travelers and Photographers', 'nexal') ?></h2>
        <!-- /wp:heading -->

        <!-- wp:paragraph {"align":"center","ploverBlockID":"2f2ec571-e7a9-4267-92f6-9bf31baef88c"} -->
        <p class="has-text-align-center"><?php esc_html_e('United by our passion for capturing the essence of the world through their lenses, We travel through remote mountains, bustling cities and serene beaches.', 'nexal') ?></p>
        <!-- /wp:paragraph -->
    </div>
    <!-- /wp:group -->

    <!-- wp:columns {"ploverBlockID":"31cdc757-394f-475e-bd51-cb617eabce2c","align":"wide"} -->
    <div class="wp-block-columns alignwide">
        <!-- wp:column {"ploverBlockID":"0a584b88-d790-412e-88c5-2d06f7bc5c4b","style":{"spacing":{"blockGap":"0.75rem","padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|small","right":"var:preset|spacing|small"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200"} -->
        <div class="wp-block-column has-neutral-200-background-color has-background"
            style="border-radius:6px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--small)">
            <!-- wp:image {"lightbox":{"enabled":false},"width":"82px","sizeSlug":"full","linkDestination":"none","ploverBlockID":"63056cf4-6c16-45a2-9e17-bf3328282fc7","align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
            <figure class="wp-block-image aligncenter size-full is-resized"
                style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">
                <img src="<?php the_nexal_asset_url('images/planning-icon.png') ?>" alt="" style="width:82px" />
            </figure>
            <!-- /wp:image -->

            <!-- wp:heading {"textAlign":"center","level":3,"ploverBlockID":"831caf51-6e14-4731-8ba8-2a25a79d9b10","style":{"typography":{"fontSize":"2rem"}}} -->
            <h3 class="wp-block-heading has-text-align-center" style="font-size:2rem"><?php esc_html_e('Planning', 'nexal') ?></h3>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"3b80218c-8acd-4232-b38a-733dbc53c9a7"} -->
            <p class="has-text-align-center"><?php esc_html_e('Personalized assistance to help individuals organize their trips efficiently.', 'nexal') ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"16a7c34c-bcaf-4926-8d2c-55020cd6a230","style":{"typography":{"textDecoration":"none"}}} -->
            <p class="has-text-align-center" style="text-decoration:none"><a href="#" target="_blank"
                    rel="noreferrer noopener"><?php esc_html_e('View ↗', 'nexal') ?></a></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"ac3ed84e-871a-4a6b-892c-97ee1e30e6a4","style":{"spacing":{"blockGap":"0.75rem","padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|small","right":"var:preset|spacing|small"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200"} -->
        <div class="wp-block-column has-neutral-200-background-color has-background"
            style="border-radius:6px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--small)">
            <!-- wp:image {"lightbox":{"enabled":false},"width":"82px","sizeSlug":"full","linkDestination":"none","ploverBlockID":"91cf8d82-d396-4f5c-9276-1d548f3b14e7","align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
            <figure class="wp-block-image aligncenter size-full is-resized"
                style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">
                <img src="<?php the_nexal_asset_url('images/blogging-icons.png') ?>" alt="" style="width:82px" />
            </figure>
            <!-- /wp:image -->

            <!-- wp:heading {"textAlign":"center","level":3,"ploverBlockID":"516916ce-210f-4c89-ad4c-c8805a00c97f","style":{"typography":{"fontSize":"2rem"}}} -->
            <h3 class="wp-block-heading has-text-align-center" style="font-size:2rem"><?php esc_html_e('Blogging', 'nexal') ?></h3>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"e0f2775f-9690-4a8c-a338-0ff881e4bc34"} -->
            <p class="has-text-align-center"><?php esc_html_e('We provides support for individuals looking to share their travel stories online.', 'nexal') ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"d7655d6a-55ca-4935-b9db-9032e7d19093","style":{"typography":{"textDecoration":"none"}}} -->
            <p class="has-text-align-center" style="text-decoration:none"><a href="#" target="_blank"
                    rel="noreferrer noopener"><?php esc_html_e('View ↗', 'nexal') ?></a></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"24fbd3f6-882a-4a1f-b970-10c632277e54","style":{"spacing":{"blockGap":"0.75rem","padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|small","right":"var:preset|spacing|small"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200"} -->
        <div class="wp-block-column has-neutral-200-background-color has-background"
            style="border-radius:6px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--small)">
            <!-- wp:image {"lightbox":{"enabled":false},"width":"82px","sizeSlug":"full","linkDestination":"none","ploverBlockID":"560e2408-6237-4e0c-8994-f345c29f6435","align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
            <figure class="wp-block-image aligncenter size-full is-resized"
                style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">
                <img src="<?php the_nexal_asset_url('images/photo-editing-icons.png') ?>" alt="" style="width:82px" />
            </figure>
            <!-- /wp:image -->

            <!-- wp:heading {"textAlign":"center","level":3,"ploverBlockID":"e2db30e7-79ec-42b5-b187-bf2f68b5b901","style":{"typography":{"fontSize":"2rem"}}} -->
            <h3 class="wp-block-heading has-text-align-center" style="font-size:2rem"><?php esc_html_e('Photo Editing', 'nexal') ?></h3>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"84596d5c-b8e7-4890-b31f-51879c24dfc6"} -->
            <p class="has-text-align-center"><?php esc_html_e('We help individuals enhance and retouch images to improve their visual appeal.', 'nexal') ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"40e557d9-8969-4d57-bf95-6a45c1d00812","style":{"typography":{"textDecoration":"none"}}} -->
            <p class="has-text-align-center" style="text-decoration:none"><a href="#" target="_blank"
                    rel="noreferrer noopener"><?php esc_html_e('View ↗', 'nexal') ?></a></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->

        <!-- wp:column {"ploverBlockID":"c70a6786-69ff-459a-b1db-264f8ab840b9","style":{"spacing":{"blockGap":"0.75rem","padding":{"top":"var:preset|spacing|x-small","bottom":"var:preset|spacing|x-small","left":"var:preset|spacing|small","right":"var:preset|spacing|small"}},"border":{"radius":"6px"}},"backgroundColor":"neutral-200"} -->
        <div class="wp-block-column has-neutral-200-background-color has-background"
            style="border-radius:6px;padding-top:var(--wp--preset--spacing--x-small);padding-right:var(--wp--preset--spacing--small);padding-bottom:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--small)">
            <!-- wp:image {"lightbox":{"enabled":false},"width":"82px","sizeSlug":"full","linkDestination":"none","ploverBlockID":"bac88061-7dff-4baf-94b7-2990d5ae90a7","align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}}} -->
            <figure class="wp-block-image aligncenter size-full is-resized"
                style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0">
                <img src="<?php the_nexal_asset_url('images/online-course-icons.png') ?>" alt="" style="width:82px" />
            </figure>
            <!-- /wp:image -->

            <!-- wp:heading {"textAlign":"center","level":3,"ploverBlockID":"778be8a6-f358-4167-8dbc-babca9d3fc48","style":{"typography":{"fontSize":"2rem"}}} -->
            <h3 class="wp-block-heading has-text-align-center" style="font-size:2rem"><?php esc_html_e('Online Courses', 'nexal') ?></h3>
            <!-- /wp:heading -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"46bbe021-8543-4371-ba0e-da2e76344a3a"} -->
            <p class="has-text-align-center"><?php esc_html_e('We offer a range of online courses to enhance your photography skills.', 'nexal') ?></p>
            <!-- /wp:paragraph -->

            <!-- wp:paragraph {"align":"center","ploverBlockID":"5b220239-c863-4436-b444-c28bd16a91e4","style":{"typography":{"textDecoration":"none"}}} -->
            <p class="has-text-align-center" style="text-decoration:none"><a href="#" target="_blank"
                    rel="noreferrer noopener"><?php esc_html_e('View ↗', 'nexal') ?></a></p>
            <!-- /wp:paragraph -->
        </div>
        <!-- /wp:column -->
    </div>
    <!-- /wp:columns -->
</div>
<!-- /wp:group -->