<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Newsstory 
 */
get_header();
?>
<section class="news-area <?php if( ! is_active_sidebar('sidebar-1')): ?>block-content-css<?php endif; ?>" id="content">
	<div class="container-fluid">
		<div class="easy-tricker-content">
			<div class="row">
				<div class="col-lg-2">
					<div class="news-text">
	                    <h2><?php esc_html_e('Latest News','newsstory-lite'); ?></h2>
	                </div>
				</div>
				<div class="col-lg-10">
					<div class="news-content">
	                    <div class="news">
	                        <ul>
		                        <?php  if ( have_posts() ) :
		                        while(have_posts()) : the_post(); ?>
		                            <li>
		                                <a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo esc_html(the_title()); ?></a>
		                            </li>
		                        <?php endwhile;  endif; ?>
	                        </ul>
	                    </div>
	                </div>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="header-content">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-6">
				<?php 
			        $newsstory_lite_args = new WP_Query(
			            array(
			                'posts_per_page' => 1,
			                'post_type' => 'post',
			                'ignore_sticky_posts' => 1
			            )
			        ); 
			    ?>
			    <?php while($newsstory_lite_args->have_posts()) : $newsstory_lite_args->the_post(); ?>

				<div class="post-style-3">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php if ( has_post_thumbnail () ): ?>
						<div class="post-thumbnail">
							<?php newsstory_post_thumbnail(); ?>
						</div>
						<?php else : ?>
						<div class="post-thumbnail">
							<img src="<?php echo esc_url (get_stylesheet_directory_uri() . '/assets/img/01.jpg' ); ?>">
						</div>
						<?php endif; ?>
						<div class="single-blog">
							<div class="newsstory-btn">
								<?php newsstory_entry_category(); ?>
							</div>
							<div class="post-content">
								<header class="entry-header">
									<?php
									if ( is_singular() ) :
										the_title( '<h1 class="entry-title">', '</h1>' );
									else :
										the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
									endif; ?>
								</header><!-- .entry-header -->
								<?php
								if ( 'post' === get_post_type() ) : ?>
									<ul class="post-meta">
										<li><?php newsstory_posted_by(); ?></li>
										<li><?php newsstory_posted_on(); ?></li>
										<li><?php newsstory_entry_comments(); ?></li>
									</ul><!-- .entry-meta -->
								<?php endif; ?>
							</div>
						</div>
					</article>
				</div>
            <?php endwhile;  wp_reset_query(); ?>
			</div>
			<div class="col-lg-6">
				<div class="row masonry-post">

				<?php 
			        $newsstory_lite_2_args = new WP_Query(
			            array(
			                'posts_per_page' => 2,
			                'post_type' => 'post',
			                'ignore_sticky_posts' => 1
			            )
			        ); 
			    ?>
				<?php while($newsstory_lite_2_args->have_posts()) : $newsstory_lite_2_args->the_post(); ?>
				<div class="col-lg-6">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php if ( has_post_thumbnail () ): ?>
						<div class="post-thumbnail">
							<?php newsstory_post_thumbnail(); ?>
						</div>
						<?php endif; ?>
						<div class="newsstory-btn">
							<?php newsstory_entry_category(); ?>
						</div>
						<div class="post-content">
							<header class="entry-header">
								<?php
								if ( is_singular() ) :
									the_title( '<h1 class="entry-title">', '</h1>' );
								else :
									the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
								endif; ?>
							</header><!-- .entry-header -->
							<?php
							if ( 'post' === get_post_type() ) : ?>
								<ul class="post-meta">
									<li><?php newsstory_posted_by(); ?></li>
									<li><?php newsstory_posted_on(); ?></li>
								</ul><!-- .entry-meta -->
							<?php endif; ?>
						</div>
					</article>
				</div>
				<?php endwhile;  wp_reset_query(); ?>	
				</div>
			</div>
		</div>
	</div>
</section>
<section class="featured-area">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<div class="newsstory-title d-flex justify-content-center align-items-center text-center">
			        <span class="ns-line left"></span>
			        <div class="content-title">
			            <h2><?php esc_html_e('Feature News','newsstory-lite'); ?></h2>
			            <span><?php esc_html_e('Top of the week news','newsstory-lite'); ?></span>
			        </div>
			        <span class="ns-line right"></span>
			    </div>
			</div>
			<div class="col-lg-12">
				<?php 
			        $newsstory_lite_3_args = new WP_Query(
			            array(
			                'posts_per_page' => 4,
			                'post_type' => 'post',
			                'ignore_sticky_posts' => 1
			            )
			        ); 
			    ?>
			    <div class="row masonry-post">
			    
                    <?php while($newsstory_lite_3_args->have_posts()) : $newsstory_lite_3_args->the_post(); ?>

                    
                        
                    <div class="col-lg-3">
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<?php if ( has_post_thumbnail () ): ?>
							<div class="post-thumbnail">
								<?php newsstory_post_thumbnail(); ?>
							</div>
							<?php endif; ?>
							<div class="newsstory-btn">
								<?php newsstory_entry_category(); ?>
							</div>
							<div class="post-content">
								<header class="entry-header">
									<?php
									if ( is_singular() ) :
										the_title( '<h1 class="entry-title">', '</h1>' );
									else :
										the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
									endif; ?>
								</header><!-- .entry-header -->
								<?php
								if ( 'post' === get_post_type() ) : ?>
									<ul class="post-meta">
										<li><?php newsstory_posted_by(); ?></li>
										<li><?php newsstory_posted_on(); ?></li>
									</ul><!-- .entry-meta -->
								<?php endif; ?>
							</div>
						</article>
                      </div>

                    <?php endwhile;  wp_reset_query(); ?>
                </div>
			</div>
		</div>
	</div>
</section>
<section class="weekly-news">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<div class="newsstory-title d-flex justify-content-center align-items-center text-center">
			        <span class="ns-line left"></span>
			        <div class="content-title">
			            <h2><?php esc_html_e('Weekly News','newsstory-lite'); ?></h2>
			            <span><?php esc_html_e('HAND-PICKED','newsstory-lite'); ?></span>
			        </div>
			        <span class="ns-line right"></span>
			    </div>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-6">
				<div class="row masonry-post">

				<?php 
			        $newsstory_lite_2_args = new WP_Query(
			            array(
			                'posts_per_page' => 2,
			                'post_type' => 'post',
			                'ignore_sticky_posts' => 1
			            )
			        ); 
			    ?>
				<?php while($newsstory_lite_2_args->have_posts()) : $newsstory_lite_2_args->the_post(); ?>
				<div class="col-lg-6">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php if ( has_post_thumbnail () ): ?>
						<div class="post-thumbnail">
							<?php newsstory_post_thumbnail(); ?>
						</div>
						<?php endif; ?>
						<div class="newsstory-btn">
							<?php newsstory_entry_category(); ?>
						</div>
						<div class="post-content">
							<header class="entry-header">
								<?php
								if ( is_singular() ) :
									the_title( '<h1 class="entry-title">', '</h1>' );
								else :
									the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
								endif; ?>
							</header><!-- .entry-header -->
							<?php
							if ( 'post' === get_post_type() ) : ?>
								<ul class="post-meta">
									<li><?php newsstory_posted_by(); ?></li>
									<li><?php newsstory_posted_on(); ?></li>
								</ul><!-- .entry-meta -->
							<?php endif; ?>
						</div>
					</article>
				</div>
				<?php endwhile;  wp_reset_query(); ?>	
				</div>
			</div>
			<div class="col-lg-6">
				<?php 
			        $newsstory_lite_args = new WP_Query(
			            array(
			                'posts_per_page' => 1,
			                'post_type' => 'post',
			                'ignore_sticky_posts' => 1
			            )
			        ); 
			    ?>
			    <?php while($newsstory_lite_args->have_posts()) : $newsstory_lite_args->the_post(); ?>

				<div class="post-style-3">
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<?php if ( has_post_thumbnail () ): ?>
						<div class="post-thumbnail">
							<?php newsstory_post_thumbnail(); ?>
						</div>
						<?php else : ?>
						<div class="post-thumbnail">
							<img src="<?php echo esc_url (get_stylesheet_directory_uri() . '/assets/img/01.jpg' ); ?>">
						</div>
						<?php endif; ?>
						<div class="single-blog">
							<div class="newsstory-btn">
								<?php newsstory_entry_category(); ?>
							</div>
							<div class="post-content">
								<header class="entry-header">
									<?php
									if ( is_singular() ) :
										the_title( '<h1 class="entry-title">', '</h1>' );
									else :
										the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
									endif; ?>
								</header><!-- .entry-header -->
								<?php
								if ( 'post' === get_post_type() ) : ?>
									<ul class="post-meta">
										<li><?php newsstory_posted_by(); ?></li>
										<li><?php newsstory_posted_on(); ?></li>
										<li><?php newsstory_entry_comments(); ?></li>
									</ul><!-- .entry-meta -->
								<?php endif; ?>
							</div>
						</div>
					</article>
				</div>
            <?php endwhile;  wp_reset_query(); ?>
			</div>
		</div>
	</div>
</section>
<section class="blog-area padding blog-bg <?php if( ! is_active_sidebar('sidebar-1')): ?>block-content-css<?php endif; ?>">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<div class="newsstory-title d-flex justify-content-center align-items-center text-center">
			        <span class="ns-line left"></span>
			        <div class="content-title">
			            <h2><?php esc_html_e('Lateset News','newsstory-lite'); ?></h2>
			            <span><?php esc_html_e('Featured articles','newsstory-lite'); ?></span>
			        </div>
			        <span class="ns-line right"></span>
			    </div>
			</div>
			<div class="col-lg-12">
				<?php
				if ( have_posts() ) :

					if ( is_home() && ! is_front_page() ) :
						?>
						<header>
							<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
						</header>
						<?php
					endif; ?>
					<div class="row masonry-post">
					<?php 

					/* Start the Loop */
					while ( have_posts() ) :
						the_post();

						/*
						 * Include the Post-Type-specific template for the content.
						 * If you want to override this in a child theme, then include a file
						 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
						 */
						get_template_part( 'template-parts/content', get_post_type() );

					endwhile; ?>
					</div>
					<?php 
					the_posts_navigation();

				else :

					get_template_part( 'template-parts/content', 'none' );

				endif;
				?>
			</div>
		</div>
	</div>
</section>
<?php
get_footer();
