<?php
/**
 * Koyel Grid functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Koyel Grid
 */

if ( ! defined( 'NEWSSTORY_LITE_VERSION' ) ) {
	$newsstory_lite_theme = wp_get_theme();
	define( 'NEWSSTORY_LITE_VERSION', $newsstory_lite_theme->get( 'Version' ) );
}

/**
 * Enqueue scripts and styles.
 */
function newsstory_lite_scripts() {
    wp_enqueue_style( 'newsstroy-lite-parent-style', get_template_directory_uri() . '/style.css',array('bootstrap','slicknav','newsstory-default-block','newsstory-style'), '', 'all');
    wp_enqueue_style( 'newsstroy-lite-main-style',get_stylesheet_directory_uri() . '/assets/css/main-style.css',array(), NEWSSTORY_LITE_VERSION, 'all');
    wp_enqueue_script( 'masonry', get_stylesheet_directory_uri() . '/assets/js/masonry.pkgd.min.js', array('jquery'), '3.5.0', true );
    wp_enqueue_script( 'newsstroy-lite-script', get_stylesheet_directory_uri() . '/assets/js/newsstroy-lite-script.js', array('jquery'), NEWSSTORY_LITE_VERSION, true );
}
add_action( 'wp_enqueue_scripts', 'newsstory_lite_scripts' ); 

/**
 * Custom excerpt length.
 */
function newsstory_lite_excerpt_length( $length ) {
    if ( is_admin() ) return $length;
    return 19;
}
add_filter( 'excerpt_length', 'newsstory_lite_excerpt_length', 999 );

/**
 * Custom excerpt More.
 */
function newsstory_lite_excerpt_more( $more ) {
    if ( is_admin() ) return $more;
    return '.';
}
add_filter( 'excerpt_more', 'newsstory_lite_excerpt_more' );