(function (e) {
    "use strict";
    var n = window.AFTHRAMPES_JS || {};
    $ = jQuery;

    n.mobileMenu = {
        init: function () {
            //var element = document.getElementsByClassName("main-navigation");

            this.toggleMenu(), this.menuMobile(), this.menuArrow();

            if (e('.aft-mobile-navigation').length) {
                var element = document.querySelector(".aft-mobile-navigation");
                this.trapFocus(element);
            }
        },

        toggleMenu: function () {
            e('#masthead').on('click', '.toggle-menu', function (event) {
                var ethis = e('.main-navigation .menu .menu-mobile');
                if (ethis.css('display') == 'block') {
                    ethis.slideUp('300');
                } else {
                    ethis.slideDown('300');
                }
                e('.ham').toggleClass('exit');
            });


            e('#masthead .main-navigation ').on('click', '.menu-mobile a button', function (event) {
                event.preventDefault();
                var ethis = e(this),
                    eparent = ethis.closest('li');

                if (eparent.find('> .children').length) {
                    var esub_menu = eparent.find('> .children');
                } else {
                    var esub_menu = eparent.find('> .sub-menu');
                }


                if (esub_menu.css('display') == 'none') {
                    esub_menu.slideDown('300');
                    ethis.addClass('active');
                } else {
                    esub_menu.slideUp('300');
                    ethis.removeClass('active');
                }
                return false;
            });
        },

        trapFocus: function (element) {
            console.log(element)
            var focusableEls = element.querySelectorAll('a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled])'),
                firstFocusableEl = focusableEls[0],
                lastFocusableEl = focusableEls[focusableEls.length - 1],
                KEYCODE_TAB = 9;

            element.addEventListener('keydown', function (e) {
                var isTabPressed = (e.key === 'Tab' || e.keyCode === KEYCODE_TAB);

                if (!isTabPressed) {
                    return;
                }

                if (e.shiftKey) /* shift + tab */ {
                    if (document.activeElement === firstFocusableEl) {
                        lastFocusableEl.focus();
                        e.preventDefault();
                    }
                } else /* tab */ {
                    if (document.activeElement === lastFocusableEl) {
                        firstFocusableEl.focus();
                        e.preventDefault();
                    }
                }

            });
        },

        menuMobile: function () {
            if (e('.main-navigation .menu > ul').length) {
                var ethis = e('.main-navigation .menu > ul'),
                    eparent = ethis.closest('.main-navigation'),
                    pointbreak = eparent.data('epointbreak'),
                    window_width = window.innerWidth;
                if (typeof pointbreak == 'undefined') {
                    pointbreak = 991;
                }
                if (pointbreak >= window_width) {
                    ethis.addClass('menu-mobile').removeClass('menu-desktop');
                    e('.main-navigation .toggle-menu').css('display', 'block');
                    e('.aft-dynamic-navigation-elements').addClass('aft-mobile-navigation');
                } else {
                    ethis.addClass('menu-desktop').removeClass('menu-mobile').css('display', '');
                    e('.main-navigation .toggle-menu').css('display', '');
                    e('.aft-dynamic-navigation-elements').removeClass('aft-mobile-navigation');
                }

            }
        },
        menuArrow: function () {
            if (e('#masthead .main-navigation div.menu > ul').length) {
                e('#masthead .main-navigation div.menu > ul .sub-menu').parent('li').find('> a').append('<button class="mobile-has-submenu">');
                e('#masthead .main-navigation div.menu > ul .children').parent('li').find('> a').append('<button class="mobile-has-submenu">');
            }
        }
    },


        n.DataBackground = function () {
            var pageSection = e(".data-bg");
            pageSection.each(function (indx) {
                if (e(this).attr("data-background")) {
                    e(this).css("background-image", "url(" + e(this).data("background") + ")");
                }
            });

            e('.bg-image').each(function () {
                var src = e(this).children('img').attr('src');
                e(this).css('background-image', 'url(' + src + ')').children('img').hide();
            });
        },

        n.setInstaHeight = function () {
            e('.insta-slider-block').each(function () {
                var img_width = e(this).find('.insta-item .af-insta-height').eq(0).innerWidth();
                e(this).find('.insta-item .af-insta-height').css('height', img_width);
            });
        },

        n.setHeaderHeight = function () {
            if (e('#main-navigation-bar').length > 0) {
                var menuHeight = e('#main-navigation-bar').height();
                e('.header-menu-part').height(menuHeight);
            }
        },


        n.Offcanvas = function () {
            e('.offcanvas-nav').sidr({
                side: 'left',
                displace: false,
            });

            e('.sidr-class-sidr-button-close').on('click', function () {
                e.sidr('close', 'sidr');
            });
        },

        // SHOW/HIDE SCROLL UP //
        n.show_hide_scroll_top = function () {
            if (e(window).scrollTop() > e(window).height() / 2) {
                e("#scroll-up").fadeIn(300);
            } else {
                e("#scroll-up").fadeOut(300);
            }
        },

        n.scroll_up = function () {
            e("#scroll-up").on("click", function () {
                e("html, body").animate({
                    scrollTop: 0
                }, 800);
                return false;
            });
        },


        n.MagnificPopup = function () {

            e('.gallery').each(function () {
                e(this).magnificPopup({
                    delegate: 'a',
                    type: 'image',
                    gallery: {
                        enabled: true
                    },
                    zoom: {
                        enabled: true,
                        duration: 300,
                        opener: function (element) {
                            return element.find('img');
                        }
                    }
                });
            });

            e('.wp-block-gallery').each(function () {
                e(this).magnificPopup({
                    delegate: 'a',
                    type: 'image',
                    gallery: {
                        enabled: true
                    },
                    zoom: {
                        enabled: true,
                        duration: 300,
                        opener: function (element) {
                            return element.find('img');
                        }
                    }
                });
            });
        },


        n.em_sticky = function () {
            jQuery('.home #secondary.aft-sticky-sidebar').theiaStickySidebar({
                additionalMarginTop: 30
            });
        },

        n.jQueryMarquee = function () {
            e('.marquee.aft-flash-slide').marquee({
                //duration in milliseconds of the marquee
                speed: 80000,
                //gap in pixels between the tickers
                gap: 0,
                //time in milliseconds before the marquee will start animating
                delayBeforeStart: 0,
                //'left' or 'right'
                // direction: 'right',
                //true or false - should the marquee be duplicated to show an effect of continues flow
                duplicated: true,
                pauseOnHover: true,
                startVisible: true
            });
        },

        n.SwiperSlider = function () {

            var MainBannerCarouselDefault = new Swiper('.banner-carousel-default', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,

                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            if (jQuery('.banner-carousel-default').length > 0) {
                $(".banner-carousel-default").on("mouseenter", function () {
                    MainBannerCarouselDefault.autoplay.stop();
                }).on("mouseleave", function () {
                    MainBannerCarouselDefault.autoplay.start();
                });
            }

            var MainBannerCarousel = new Swiper('.banner-carousel-slider', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 2,

                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                },
                breakpoints: {
                    1024: {
                        slidesPerView: 2,
                    },
                    768: {
                        slidesPerView: 2,
                    },
                    480: {
                        slidesPerView: 1,
                    }
                }
            });

            if (jQuery('.banner-carousel-slider').length > 0) {
                $(".banner-carousel-slider").on("mouseenter", function () {
                    MainBannerCarousel.autoplay.stop();
                }).on("mouseleave", function () {
                    MainBannerCarousel.autoplay.start();
                });
            }

            var MainBannerSliderSingle = new Swiper('.banner-main-slider', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,

                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            if (jQuery('.banner-main-slider').length > 0) {
                $(".banner-main-slider").on("mouseenter", function () {
                    MainBannerSliderSingle.autoplay.stop();
                }).on("mouseleave", function () {
                    MainBannerSliderSingle.autoplay.start();
                });
            }

            var MainBannerCarouselSingle = new Swiper('.banner-single-slider', {
                direction: 'horizontal',

                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,
                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            if (jQuery('.banner-single-slider').length > 0) {
                $(".banner-single-slider").on("mouseenter", function () {
                    MainBannerCarouselSingle.autoplay.stop();
                }).on("mouseleave", function () {
                    MainBannerCarouselSingle.autoplay.start();
                });
            }


            var WidgetContentCarousel = new Swiper('.posts-carousel', {
                direction: 'horizontal',
                loop: true,

                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 3,
                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                },
                breakpoints: {
                    1024: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 2,
                    },
                    480: {
                        slidesPerView: 1,
                    }
                }
            });

            if (jQuery('.posts-carousel').length > 0) {
                $(".posts-carousel").on("mouseenter", function () {
                    WidgetContentCarousel.autoplay.stop();
                }).on("mouseleave", function () {
                    WidgetContentCarousel.autoplay.start();
                });
            }

            var WidgetSidebarCarousel = new Swiper('#secondary .posts-carousel', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },

                slidesPerView: 1,
                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });
            if (jQuery('#secondary .posts-carousel').length > 0) {
                $("#secondary .posts-carousel").on("mouseenter", function () {
                    WidgetSidebarCarousel.autoplay.stop();
                }).on("mouseleave", function () {
                    WidgetSidebarCarousel.autoplay.start();
                });
            }


            var WidgetFooterCarousel = new Swiper('.site-footer .posts-carousel', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,

                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            if (jQuery('.site-footer .posts-carousel').length > 0) {
                $(".site-footer .posts-carousel").on("mouseenter", function () {
                    WidgetFooterCarousel.autoplay.stop();
                }).on("mouseleave", function () {
                    WidgetFooterCarousel.autoplay.start();
                });
            }

            var WidgetSidrCarousel = new Swiper('#sidr .posts-carousel', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,

                spaceBetween: 20,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev'
                }
            });

            if (jQuery('#sidr .posts-carousel').length > 0) {
                $("#sidr .posts-carousel").hover(function () {
                    WidgetSidrCarousel.autoplay.stop();
                }, function () {
                    WidgetSidrCarousel.autoplay.start();
                });
            }

            var InstaCarousel = new Swiper('.instagram-carousel', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 6,

                spaceBetween: 0,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                breakpoints: {
                    1024: {
                        slidesPerView: 4,
                    },
                    768: {
                        slidesPerView: 3,
                    },
                    480: {
                        slidesPerView: 1,
                    }
                }
            });

            if (jQuery('.instagram-carousel').length > 0) {
                $(".instagram-carousel").on("mouseenter", function () {
                    InstaCarousel.autoplay.stop();
                }).on("mouseleave", function () {
                    InstaCarousel.autoplay.start();
                });
            }

            var WidgetSlider = new Swiper('.posts-slider', {
                direction: 'horizontal',
                loop: true,
                autoplay: {
                    delay: 6000,
                },
                slidesPerView: 1,
                spaceBetween: 0,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                }
            });
            if (jQuery('.posts-slider').length > 0) {
                $(".posts-slider").on("mouseenter", function () {
                    WidgetSlider.autoplay.stop();
                }).on("mouseleave", function () {
                    WidgetSlider.autoplay.start();
                });
            }


            //             var VerticalSlider = new Swiper('.vertical-slider', {
            //                 direction: 'vertical',
            //                 loop: true,
            //                 slidesPerView: 5,

            //                 spaceBetween: 10,
            //                  autoplay: {
            // delay: 6000,
            // },
            //                 breakpoints: {
            //                     // when window width is <= 320px
            //                     768: {
            //                         allowTouchMove: 0,

            //                     },
            //                 }
            //             });

            //             if (jQuery('.vertical-slider').length > 0) {
            //                 $(".vertical-slider").on("mouseenter", function () {
            //                     VerticalSlider.autoplay.stop();
            //                 }).on("mouseleave", function () {
            //                     VerticalSlider.autoplay.start();
            //                 });
            //             }

            //             var VerticalPostsSlider = new Swiper('.trending-posts-vertical', {
            //                 direction: 'vertical',
            //                 loop: true,
            //                 slidesPerView: 5,
            //                 spaceBetween: 10,
            //                  autoplay: {
            // delay: 6000,
            // },
            //                 breakpoints: {
            //                     // when window width is <= 320px
            //                     768: {
            //                         allowTouchMove: 0,

            //                     },
            //                 }
            //             });

            //             if (jQuery('.trending-posts-vertical').length > 0) {
            //                 $(".trending-posts-vertical").on("mouseenter", function () {
            //                     VerticalPostsSlider.autoplay.stop();
            //                 }).on("mouseleave", function () {
            //                     VerticalPostsSlider.autoplay.start();
            //                 });
            //             }

            let VerticalSliderInstance;
            let VerticalPostsSliderInstance;

            function initResponsiveVerticalSliders() {

                const w = window.innerWidth;

                let slides = 5;            // default for desktop
                let direction = 'vertical'; // default for desktop

                if (w <= 576) {
                    // Mobile
                    slides = 1;
                    direction = 'horizontal';
                } else if (w <= 768) {
                    // Tablet
                    slides = 2;
                    direction = 'horizontal';
                }

                // Destroy previous instances
                if (VerticalSliderInstance) VerticalSliderInstance.destroy(true, true);
                if (VerticalPostsSliderInstance) VerticalPostsSliderInstance.destroy(true, true);

                // First slider
                VerticalSliderInstance = new Swiper('.vertical-slider', {
                    direction,
                    slidesPerView: slides,
                    spaceBetween: 10,
                    autoplay: { delay: 6000 },
                });

                $(".vertical-slider").on("mouseenter", () => VerticalSliderInstance.autoplay.stop())
                    .on("mouseleave", () => VerticalSliderInstance.autoplay.start());

                // Second slider
                VerticalPostsSliderInstance = new Swiper('.trending-posts-vertical', {
                    direction,
                    slidesPerView: slides,
                    spaceBetween: 10,
                    autoplay: { delay: 6000 },
                });

                $(".trending-posts-vertical").on("mouseenter", () => VerticalPostsSliderInstance.autoplay.stop())
                    .on("mouseleave", () => VerticalPostsSliderInstance.autoplay.start());
            }

            initResponsiveVerticalSliders();
            window.addEventListener('resize', initResponsiveVerticalSliders);



            // Video slider part starts

            var part1 = '<div class=swiper-pagination></div>';
            $('#swiper-press').append(part1);


            /* change active class when click */
            $(".swiper-container-videos .swiper-wrapper .swiper-slide a").on('click', function () {
                $(this).closest(".swiper-slide").addClass("selected").siblings().removeClass("selected");
                YoutubeVideoSlider.slideTo(YoutubeVideoSlider.clickedIndex);
            });

            $(".swiper-container-videos .swiper-slide").first().addClass("selected");

            var YoutubeVideoSlider = new Swiper(".swiper-container-videos", {
                // If loop true set photoswipe - counterEl: false
                loop: false,
                slidesPerView: 4,
                spaceBetween: 10,

                centeredSlides: false,
                // If we need pagination
                navigation: {
                    nextEl: '.swiper-custom-next.swiper-button-next',
                    prevEl: '.swiper-custom-prev.swiper-button-prev'
                },
                keyboard: {
                    enabled: true,
                    onlyInViewport: true
                },
                breakpoints: {
                    1024: {
                        slidesPerView: 4,
                    },
                    768: {
                        slidesPerView: 3,
                    },
                    480: {
                        slidesPerView: 2,
                    }
                }
            });

        },
        n.MasonryBlog = function () {
            if (e('.aft-masonry-archive-posts').length > 0) {
                jQuery('.aft-masonry-archive-posts').masonry();
            }
        },

        e(function () {
            n.mobileMenu.init(), n.DataBackground(), n.setInstaHeight(), n.em_sticky(), n.MagnificPopup(), n.jQueryMarquee(), n.setHeaderHeight(), n.Offcanvas(), n.scroll_up();
        }), e(window).on('scroll', function () {
            n.show_hide_scroll_top();
        }), e(window).on('resize', function () {
            n.mobileMenu.menuMobile();
        }), e(window).on('load', function () {
            n.MasonryBlog();
            n.SwiperSlider();
            e('#loader-wrapper').fadeOut();
            e('#af-preloader').delay(500).fadeOut('slow');
            e(".af-search-click").on('click', function () {
                e("#af-search-wrap").toggleClass("af-search-toggle");
            });
            jQuery('.search-overlay .search-icon').on('click', function () {
                jQuery(this).parent().toggleClass('reveal-search');
                return false;
            });


        })
})(jQuery);

