<?php
/**
 * Template part for displaying service section with categories
 *
 * @package Newspaper Magazine Blog
 */

if (get_theme_mod('newspaper_magazine_blog_show_hide_sec', true)) : ?>
  <section id="service-sec" class="my-5">
    <div class="container">
        <div class="row">
          <div class="col-lg-8 col-md-8 align-self-center">
            <?php
            $newspaper_magazine_blog_title = get_theme_mod('newspaper_magazine_blog_featured_section_title', 'Our Services');
            if ($newspaper_magazine_blog_title) : ?>
              <h2 class="text-uppercase"><?php echo esc_html($newspaper_magazine_blog_title); ?></h2>
            <?php endif; ?>
          </div>
          <div class="col-lg-4 col-md-4 align-self-center">
            <div class="main-view-btn">
              <?php
              $newspaper_magazine_blog_btn_text = get_theme_mod('newspaper_magazine_blog_product_section_btn_text1', __('View All', 'newspaper-magazine-blog'));
              $newspaper_magazine_blog_btn_link = get_theme_mod('newspaper_magazine_blog_product_section_btn_link1');
              if (!empty($newspaper_magazine_blog_btn_text) && !empty($newspaper_magazine_blog_btn_link)) : ?>
                <a class="viewall-btn mb-3" href="<?php echo esc_url($newspaper_magazine_blog_btn_link); ?>">
                  <?php echo esc_html($newspaper_magazine_blog_btn_text); ?>
                  <span class="screen-reader-text"><?php echo esc_html($newspaper_magazine_blog_btn_text); ?></span>
                </a>
              <?php endif; ?>
            </div>
          </div>
    </div>

      <?php
      $newspaper_magazine_blog_column_count = get_theme_mod('newspaper_magazine_blog_column_count', 10);
      $newspaper_magazine_blog_fallback_image = get_stylesheet_directory_uri() . '/assets/images/cat1.png';

      // Get all categories (you can restrict to a parent category if needed)
      $categories = get_categories([
        'orderby' => 'name',
        'order'   => 'ASC',
        'number'  => $newspaper_magazine_blog_column_count, // Limit to number of columns
      ]);
      ?>

      <div class="row">
        <?php foreach ($categories as $newspaper_magazine_blog_i => $newspaper_magazine_blog_cat) : ?>
          <div class="col-lg-3 col-md-3 mb-4">
            <div class="cat-inner-box mb-3 text-center">
              <?php if ($newspaper_magazine_blog_i % 2 === 0) : ?>
                <!-- Even column: Content first -->
                <div class="inner-content">
                  <h3 class="text-uppercase">
                    <a href="<?php echo esc_url(get_category_link($newspaper_magazine_blog_cat->term_id)); ?>">
                      <?php echo esc_html($newspaper_magazine_blog_cat->name); ?>
                    </a>
                  </h3>
                </div>
                <img src="<?php echo esc_url($newspaper_magazine_blog_fallback_image); ?>" alt="<?php echo esc_attr($newspaper_magazine_blog_cat->name); ?>" class="img-fluid mt-4" />
              <?php else : ?>
                <!-- Odd column: Image first -->
                <img src="<?php echo esc_url($newspaper_magazine_blog_fallback_image); ?>" alt="<?php echo esc_attr($newspaper_magazine_blog_cat->name); ?>" class="img-fluid mb-4" />
                <div class="inner-content">
                  <h3>
                    <a href="<?php echo esc_url(get_category_link($newspaper_magazine_blog_cat->term_id)); ?>">
                      <?php echo esc_html($newspaper_magazine_blog_cat->name); ?>
                    </a>
                  </h3>
                </div>
              <?php endif; ?>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>
<?php endif; ?>