<?php
/**
 * Template part for displaying slider section
 *
 * @package Newspaper Magazine Blog
 * @subpackage newspaper_magazine_blog
 */
?>
<?php 

$newspaper_magazine_blog_default_image_large = get_template_directory_uri() . '/assets/images/post-img1.png';
$newspaper_magazine_blog_default_image_small = get_template_directory_uri() . '/assets/images/post-img2.png';

$newspaper_magazine_blog_main_expert_wrap = absint(get_theme_mod('newspaper_magazine_blog_slider_section_show', true));
if ($newspaper_magazine_blog_main_expert_wrap == 1): 
?>
<section id="projetcs-sec">
    <div class="container">
        <?php 
        $newspaper_magazine_blog_post_count = absint(get_theme_mod('newspaper_magazine_blog_projetcs_number', 7)); 
        ?>
        <!-- Tab Buttons -->
        <div class="tab">
            <?php 
            for ($newspaper_magazine_blog_j = 1; $newspaper_magazine_blog_j <= $newspaper_magazine_blog_post_count; $newspaper_magazine_blog_j++) : 
                $newspaper_magazine_blog_tab_text_raw = get_theme_mod("newspaper_magazine_blog_projetcs_text" . $newspaper_magazine_blog_j);
                $newspaper_magazine_blog_tab_bg_image = get_theme_mod("newspaper_magazine_blog_project_tab_image" . $newspaper_magazine_blog_j);

                if (!empty($newspaper_magazine_blog_tab_text_raw)) : 
                    $newspaper_magazine_blog_tab_id = sanitize_title_with_dashes($newspaper_magazine_blog_tab_text_raw);
                    ?>
                    <button 
                        class="tablinks <?php echo ($newspaper_magazine_blog_j === 1) ? 'active' : ''; ?>" 
                        onclick="newspaper_magazine_blog_projetcs_tab(event, '<?php echo esc_attr($newspaper_magazine_blog_tab_id); ?>')"
                        style="<?php echo ($newspaper_magazine_blog_tab_bg_image) ? 'background-image: url(' . esc_url($newspaper_magazine_blog_tab_bg_image) . '); background-size: cover; background-position: center;' : ''; ?>"
                    >
                        <?php 
                        printf( esc_html__( '#%s', 'newspaper-magazine-blog' ), esc_html( $newspaper_magazine_blog_tab_text_raw ) );
                        ?>
                    </button>
                <?php 
                endif;
            endfor; 
            ?>
        </div>

        <!-- Tab Content -->
        <?php for ($newspaper_magazine_blog_j = 1; $newspaper_magazine_blog_j <= $newspaper_magazine_blog_post_count; $newspaper_magazine_blog_j++) :
            $newspaper_magazine_blog_tab_text = get_theme_mod("newspaper_magazine_blog_projetcs_text$newspaper_magazine_blog_j");
            $newspaper_magazine_blog_cat_slug = get_theme_mod("newspaper_magazine_blog_projetcs_category$newspaper_magazine_blog_j");

            if (!empty($newspaper_magazine_blog_tab_text) && !empty($newspaper_magazine_blog_cat_slug)) :
                $tab_id = sanitize_title_with_dashes($newspaper_magazine_blog_tab_text);
                $newspaper_magazine_blog_query = new WP_Query(array(
                    'category_name'  => sanitize_text_field($newspaper_magazine_blog_cat_slug),
                    'posts_per_page' => 4,
                ));
                ?>
                <div id="<?php echo esc_attr($tab_id); ?>" class="tabcontent mt-3 <?php echo ($newspaper_magazine_blog_j === 1) ? 'active' : ''; ?>">
                    <div class="row featured-post-wrapper">
                        <?php 
                        $newspaper_magazine_blog_post_index = 0;
                        if ($newspaper_magazine_blog_query->have_posts()) :
                            while ($newspaper_magazine_blog_query->have_posts()) : $newspaper_magazine_blog_query->the_post(); ?>
                                <?php if ($newspaper_magazine_blog_post_index === 0) : ?>
                                    <!-- Large First Post -->
                                    <div class="col-lg-8 col-md-7">
                                        <div class="post-box large-post">
                                            <div class="post-thumbnail">
                                                <?php if ( has_post_thumbnail() ) {
                                                    the_post_thumbnail( 'full' );
                                                } else {
                                                    $default_image_url = esc_url( $newspaper_magazine_blog_default_image_large );
                                                    $default_image_alt = esc_attr__( 'Default Image', 'newspaper-magazine-blog' );
                                                    ?>
                                                    <img src="<?php echo $default_image_url; ?>" alt="<?php echo $default_image_alt; ?>" />
                                                <?php } ?>
                                            </div>
                                            <div class="post-content">
                                                <span class="post-category text-uppercase"><?php $newspaper_magazine_blog_cat = get_the_category(); echo !empty($newspaper_magazine_blog_cat) ? esc_html($newspaper_magazine_blog_cat[0]->name) : ''; ?></span>
                                                <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                <div class="meta-info">
                                                    <span><i class="fa fa-user"></i> <?php the_author(); ?></span>
                                                    <span class="ms-2 ms-md-3">
                                                        <i class="far fa-calendar me-1"></i>
                                                        <a href="<?php echo esc_url( get_day_link( get_the_time('Y'), get_the_time('m'), get_the_time('d') ) ); ?>">
                                                            <?php echo esc_html( get_the_date() ); ?>
                                                        </a>
                                                    </span>
                                                    <span class="ms-2 ms-md-3">
                                                        <i class="fa fa-clock me-1" aria-hidden="true"></i>
                                                        <?php
                                                        printf(
                                                            esc_html__( '%s ago', 'newspaper-magazine-blog' ),
                                                            esc_html( human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) )
                                                        );
                                                        ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-5">
                                <?php else : ?>
                                    <!-- Small Posts -->
                                    <div class="post-box small-post">
                                            <div class="post-thumbnail">
                                                <div class="post-thumbnail">
                                                    <?php if ( has_post_thumbnail() ) {
                                                        the_post_thumbnail( 'full' );
                                                    } else { ?>
                                                        <img 
                                                            src="<?php echo esc_url( $newspaper_magazine_blog_default_image_large ); ?>" 
                                                            alt="<?php echo esc_attr__( 'Default Image', 'newspaper-magazine-blog' ); ?>" 
                                                        />
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <div class="post-content">
                                                <span class="post-category text-uppercase"><?php $newspaper_magazine_blog_cat = get_the_category(); echo !empty($newspaper_magazine_blog_cat) ? esc_html($newspaper_magazine_blog_cat[0]->name) : ''; ?></span>
                                                <h3 class="post-title mb-1"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                <p class="main-serv-content mt-0"><?php echo esc_html(wp_trim_words(wp_kses_post(get_the_content()), 20)); ?></p>
                                                <div class="meta-info">
                                                    <span>
                                                      <i class="far fa-calendar"></i> 
                                                      <?php echo esc_html( get_the_date() ); ?>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                <?php endif; 
                                $newspaper_magazine_blog_post_index++;
                            endwhile; ?>
                                    </div> <!-- Close col-lg-4 -->
                                <?php
                            wp_reset_postdata();
                        else : ?>
                            <p><?php esc_html_e('No posts found.', 'newspaper-magazine-blog'); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif;
        endfor; ?>
    </div>
</section>
<?php endif; ?>