<?php
/*
* Display Logo and contact details
*/
?>
<div class="main-header">
  <?php if (get_theme_mod('newspaper_magazine_blog_topbar_visibility', true)) : ?>
  <div class="top-main py-md-2 py-3">
    <div class="container">
      <div class="row">
          <div class="col-lg-8 col-md-9 col-12 align-self-center">
              <div class="contact">
                <?php if (!empty(get_theme_mod('newspaper_magazine_blog_query_link')) && !empty(get_theme_mod('newspaper_magazine_blog_query_text','Have any question?'))) : ?>
                  <span class="query mb-md-0 mb-2">
                    <a href="<?php echo esc_url(get_theme_mod('newspaper_magazine_blog_query_link', '')); ?>">
                      <?php if (!empty(get_theme_mod('newspaper_magazine_blog_query_text','Have any question?'))) : ?>
                        <?php echo esc_html(get_theme_mod('newspaper_magazine_blog_query_text', 'Have any question?')); ?>
                      <?php endif; ?>
                    </a>
                  </span>
                <?php endif; ?>
                <?php if (get_theme_mod('newspaper_magazine_blog_mail')) : ?>
                  <p class="mb-md-0 mb-2 contact-content ms-lg-4 ms-md-2 ms-0">
                    <i class="fas fa-envelope me-1"></i><a href="mailto:<?php echo esc_html(get_theme_mod('newspaper_magazine_blog_mail')); ?>">
                        <?php echo esc_html(get_theme_mod('newspaper_magazine_blog_mail')); ?>
                    </a>
                  </p>
                <?php endif; ?>
                <?php if (get_theme_mod('newspaper_magazine_blog_call')) : ?>
                  <p class="mb-md-0 mb-2 contact-content call ms-lg-4 ms-md-2 ms-0">
                    <i class="fas fa-phone me-1"></i><span><a href="tel:<?php echo esc_html(get_theme_mod('newspaper_magazine_blog_call')); ?>">
                            <?php echo esc_html(get_theme_mod('newspaper_magazine_blog_call')); ?>
                    </a>
                  </p>
                <?php endif; ?>
              </div>
          </div>
          <div class="col-lg-4 col-md-3 col-12 langauge-box align-self-center d-flex align-items-center justify-content-md-end justify-content-center">
            <span class="globe-icon mb-md-0 mb-2">
              <?php
              // Get the globe icon link from theme mod
              $newspaper_magazine_blog_globe_icon_link = get_theme_mod( 'newspaper_magazine_blog_interactive_globe_symbol' );
              // Only display if the link is not empty
              if ( ! empty( $newspaper_magazine_blog_globe_icon_link ) ) : ?>
                <a class="viewall-btn mb-3"
                   href="<?php echo esc_url( $newspaper_magazine_blog_globe_icon_link ); ?>"
                   aria-label="<?php echo esc_attr__( 'Interactive Globe Link', 'newspaper-magazine-blog' ); ?>">
                  <i class="fas fa-globe"></i>
                </a>
              <?php endif; ?>
            </span>
            <span class="translate-btn d-flex ms-lg-4 ms-md-2 ms-0 mb-md-0 mb-2">
              <?php if (get_theme_mod('newspaper_magazine_blog_cart_language_translator', true) && class_exists('GTranslate')) : ?>
                  <div class="translate-lang position-relative d-md-inline-block me-3">
                      <?php echo wp_kses_post(do_shortcode('[gtranslate]')); ?>
                  </div>
              <?php endif; ?>
            </span>
            <span class="currency me-md-2 mb-md-0 mb-2">
              <?php if (get_theme_mod('newspaper_magazine_blog_currency_switcher', true) && class_exists('WooCommerce')) : ?>
                  <div class="currency-box d-md-inline-block">
                      <?php echo wp_kses_post(do_shortcode('[woocommerce_currency_switcher_drop_down_box]')); ?>
                  </div>
              <?php endif; ?>
            </span>
        </div>
          </div>
      </div>
    </div>
  </div>
<?php endif; ?>

  <div class="headerbox">
    <div class="menubox">
      <div class="container">
        <div class="row">
          <div class="col-lg-3 col-md-4 logo-col align-self-center">
            <div class="logo my-lg-2 my-3">
              <?php if( has_custom_logo() ) newspaper_magazine_blog_the_custom_logo(); ?>
              <?php if(get_theme_mod('newspaper_magazine_blog_site_title',true) == 1){ ?>
                <?php if (is_front_page() && is_home()) : ?>
                  <h1 class="text-capitalize">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </h1> 
                <?php else : ?>
                  <p class="text-capitalize site-title mb-1">
                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                  </p>
                <?php endif; ?>
              <?php }?>
              <?php $newspaper_magazine_blog_description = get_bloginfo( 'description', 'display' );
              if ( $newspaper_magazine_blog_description || is_customize_preview() ) : ?>
                <?php if(get_theme_mod('newspaper_magazine_blog_site_tagline',false)){ ?>
                  <p class="site-description mb-0"><?php echo esc_html($newspaper_magazine_blog_description); ?></p>
                <?php }?>
              <?php endif; ?>
            </div>
          </div>
          <div class="col-lg-6 col-md-2 align-self-center">
            <?php get_template_part('template-parts/navigation/site-nav'); ?>
          </div>
          <div class="col-lg-3 col-md-6 btn-col align-self-center">
            <?php if (!empty(get_theme_mod('newspaper_magazine_blog_subscribe_link')) && !empty(get_theme_mod('newspaper_magazine_blog_subscribe_text','Subscribe'))) : ?>
                <span class="subscribe btns">
                  <a href="<?php echo esc_url(get_theme_mod('newspaper_magazine_blog_subscribe_link', '')); ?>">
                    <?php if (!empty(get_theme_mod('newspaper_magazine_blog_subscribe_text','Subscribe'))) : ?>
                      <?php echo esc_html(get_theme_mod('newspaper_magazine_blog_subscribe_text','Subscribe')); ?>
                    <?php endif; ?>
                  </a>
                </span>
              <?php endif; ?>

              <?php if (!empty(get_theme_mod('newspaper_magazine_blog_sign_in_link')) && !empty(get_theme_mod('newspaper_magazine_blog_sign_in_text','Sign in'))) : ?>
                <span class="signs btns ps-lg-3 ps-md-2 ps-0">
                  <a href="<?php echo esc_url(get_theme_mod('newspaper_magazine_blog_subscribe_link', '')); ?>">
                    <?php if (!empty(get_theme_mod('newspaper_magazine_blog_sign_in_text','Sign in'))) : ?>
                      <?php echo esc_html(get_theme_mod('newspaper_magazine_blog_sign_in_text','Sign in')); ?>
                    <?php endif; ?>
                  </a>
                </span>
              <?php endif; ?>

              <span class="search-bar ms-xl-4 ms-0 ms-md-3">
                <button type="button" class="open-search"><i class="fas fa-search"></i></button>
              </span>
          </div>
          <div class="search-outer">
            <div class="inner_searchbox w-100 h-100">
                <?php get_search_form(); ?>
            </div>
            <button type="button" class="search-close"><?php esc_html_e('CLOSE', 'newspaper-magazine-blog'); ?></button>
          </div> 
        </div>
      </div>
    </div>
  </div>
</div>