<?php
/**
 * Template for displaying search forms in Newspaper Magazine Blog
 *
 * @package Newspaper Magazine Blog
 * @subpackage newspaper_magazine_blog
 */
?>

<?php $unique_id = esc_attr( uniqid( 'search-form-' ) ); ?>

<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">	
	<input type="search" id="<?php echo esc_attr( $unique_id ); ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search &hellip;', 'placeholder', 'newspaper-magazine-blog' ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
	<button type="submit" class="search-submit"><?php echo esc_html_x( 'Search', 'submit button', 'newspaper-magazine-blog' ); ?></button>
</form>