<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Newspaper Magazine Blog
 * @subpackage newspaper_magazine_blog
 */

/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function newspaper_magazine_blog_categorized_blog() {
	$newspaper_magazine_blog_category_count = get_transient( 'newspaper_magazine_blog_categories' );

	if ( false === $newspaper_magazine_blog_category_count ) {
		// Create an array of all the categories that are attached to posts.
		$newspaper_magazine_blog_categories = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$newspaper_magazine_blog_category_count = count( $newspaper_magazine_blog_categories );

		set_transient( 'newspaper_magazine_blog_categories', $newspaper_magazine_blog_category_count );
	}

	// Allow viewing case of 0 or 1 categories in post preview.
	if ( is_preview() ) {
		return true;
	}

	return $newspaper_magazine_blog_category_count > 1;
}

if ( ! function_exists( 'newspaper_magazine_blog_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 * @since Newspaper Magazine Blog
 */
function newspaper_magazine_blog_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;

/**
 * Flush out the transients used in newspaper_magazine_blog_categorized_blog.
 */
function newspaper_magazine_blog_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'newspaper_magazine_blog_categories' );
}
add_action( 'edit_category', 'newspaper_magazine_blog_category_transient_flusher' );
add_action( 'save_post',     'newspaper_magazine_blog_category_transient_flusher' );