<?php
/**
 * Newspaper Magazine Blog: Customizer
 *
 * @package Newspaper Magazine Blog
 * @subpackage newspaper_magazine_blog
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function Newspaper_Magazine_Blog_Customize_register( $wp_customize ) {

	// Pro Version
    class newspaper_magazine_blog_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( NEWSPAPER_MAGAZINE_BLOG_BUY_TEXT,'newspaper-magazine-blog' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function newspaper_magazine_blog_sanitize_custom_control( $input ) {
        return $input;
    }

	require get_parent_theme_file_path('/inc/controls/range-slider-control.php');

	require get_parent_theme_file_path('/inc/controls/icon-changer.php');
	
	// Register the custom control type.
	$wp_customize->register_control_type( 'Newspaper_Magazine_Blog_Toggle_Control' );
	
	//Register the sortable control type.
	$wp_customize->register_control_type( 'newspaper_magazine_blog_Control_Sortable' );

	//add home page setting pannel
	$wp_customize->add_panel( 'newspaper_magazine_blog_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Custom Home page', 'newspaper-magazine-blog' ),
	    'description' => __( 'Description of what this panel does.', 'newspaper-magazine-blog' ),
	) );
	
	//TP GENRAL OPTION
	$wp_customize->add_section('newspaper_magazine_blog_tp_general_settings',array(
        'title' => __('TP General Option', 'newspaper-magazine-blog'),
        'priority' => 1,
        'panel' => 'newspaper_magazine_blog_panel_id'
    ) );

    $wp_customize->add_setting('newspaper_magazine_blog_tp_body_layout_settings',array(
        'default' => 'Full',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
    $wp_customize->add_control('newspaper_magazine_blog_tp_body_layout_settings',array(
        'type' => 'radio',
        'label'     => __('Body Layout Setting', 'newspaper-magazine-blog'),
        'description'   => __('This option work for complete body, if you want to set the complete website in container.', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_tp_general_settings',
        'choices' => array(
            'Full' => __('Full','newspaper-magazine-blog'),
            'Container' => __('Container','newspaper-magazine-blog'),
            'Container Fluid' => __('Container Fluid','newspaper-magazine-blog')
        ),
	) );

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('newspaper_magazine_blog_sidebar_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sidebar_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Sidebar Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for blog page, blog single page, archive page and search page.', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_tp_general_settings',
        'choices' => array(
            'full' => __('Full','newspaper-magazine-blog'),
            'left' => __('Left','newspaper-magazine-blog'),
            'right' => __('Right','newspaper-magazine-blog'),
            'three-column' => __('Three Columns','newspaper-magazine-blog'),
            'four-column' => __('Four Columns','newspaper-magazine-blog'),
            'grid' => __('Grid Layout','newspaper-magazine-blog')
        ),
	) );

	// Add Settings and Controls for post sidebar Layout
	$wp_customize->add_setting('newspaper_magazine_blog_sidebar_single_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sidebar_single_post_layout',array(
        'type' => 'radio',
        'label'     => __('Single Post Sidebar Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for single blog page', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_tp_general_settings',
        'choices' => array(
            'full' => __('Full','newspaper-magazine-blog'),
            'left' => __('Left','newspaper-magazine-blog'),
            'right' => __('Right','newspaper-magazine-blog'),
        ),
	) );

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('newspaper_magazine_blog_sidebar_page_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sidebar_page_layout',array(
        'type' => 'radio',
        'label'     => __('Page Sidebar Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for pages.', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_tp_general_settings',
        'choices' => array(
            'full' => __('Full','newspaper-magazine-blog'),
            'left' => __('Left','newspaper-magazine-blog'),
            'right' => __('Right','newspaper-magazine-blog')
        ),
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_sticky', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_sticky', array(
		'label'       => esc_html__( 'Show Sticky Header', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_tp_general_settings',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_sticky',
	) ) );

	//tp typography option
	$newspaper_magazine_blog_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'Inter'                  => 'Inter',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Karla'                  => 'Karla',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Manrope'           	 => 'Manrope',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Oxanium'                => 'Oxanium',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Roboto Serif'           => 'Roboto Serif',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Satisfy'                => 'Satisfy',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	$wp_customize->add_section('newspaper_magazine_blog_typography_option',array(
		'title'         => __('TP Typography Option', 'newspaper-magazine-blog'),
		'priority' => 1,
		'panel' => 'newspaper_magazine_blog_panel_id'
   	));

   	$wp_customize->add_setting('newspaper_magazine_blog_heading_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices',
	));
	$wp_customize->add_control(	'newspaper_magazine_blog_heading_font_family', array(
		'section' => 'newspaper_magazine_blog_typography_option',
		'label'   => __('heading Fonts', 'newspaper-magazine-blog'),
		'type'    => 'select',
		'choices' => $newspaper_magazine_blog_font_array,
	));

	$wp_customize->add_setting('newspaper_magazine_blog_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices',
	));
	$wp_customize->add_control(	'newspaper_magazine_blog_body_font_family', array(
		'section' => 'newspaper_magazine_blog_typography_option',
		'label'   => __('Body Fonts', 'newspaper-magazine-blog'),
		'type'    => 'select',
		'choices' => $newspaper_magazine_blog_font_array,
	));

	//TP Preloader Option
	$wp_customize->add_section('newspaper_magazine_blog_prelaoder_option',array(
		'title'         => __('TP Preloader Option', 'newspaper-magazine-blog'),
		'priority' => 1,
		'panel' => 'newspaper_magazine_blog_panel_id'
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_preloader_show_hide', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_preloader_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Preloader Option', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_prelaoder_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_preloader_show_hide',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_tp_preloader_color1_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_tp_preloader_color1_option', array(
			'label'     => __('Preloader First Ring Color', 'newspaper-magazine-blog'),
	    'description' => __('It will change the complete theme preloader ring 1 color in one click.', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_prelaoder_option',
	    'settings' => 'newspaper_magazine_blog_tp_preloader_color1_option',
  	)));

  	$wp_customize->add_setting( 'newspaper_magazine_blog_tp_preloader_color2_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_tp_preloader_color2_option', array(
			'label'     => __('Preloader Second Ring Color', 'newspaper-magazine-blog'),
	    'description' => __('It will change the complete theme preloader ring 2 color in one click.', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_prelaoder_option',
	    'settings' => 'newspaper_magazine_blog_tp_preloader_color2_option',
  	)));

  	$wp_customize->add_setting( 'newspaper_magazine_blog_tp_preloader_bg_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_tp_preloader_bg_color_option', array(
			'label'     => __('Preloader Background Color', 'newspaper-magazine-blog'),
	    'description' => __('It will change the complete theme preloader bg color in one click.', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_prelaoder_option',
	    'settings' => 'newspaper_magazine_blog_tp_preloader_bg_color_option',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_preloader_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_preloader_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_prelaoder_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//TP Color Option
	$wp_customize->add_section('newspaper_magazine_blog_color_option',array(
     'title'         => __('TP Color Option', 'newspaper-magazine-blog'),
     'priority' => 1,
     'panel' => 'newspaper_magazine_blog_panel_id'
    ) );
    
	$wp_customize->add_setting( 'newspaper_magazine_blog_tp_color_option_first', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_tp_color_option_first', array(
			'label'     => __('Theme First Color', 'newspaper-magazine-blog'),
	    'description' => __('It will change the complete theme color in one click.', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_color_option',
	    'settings' => 'newspaper_magazine_blog_tp_color_option_first',
  	)));

	//TP Blog Option
	$wp_customize->add_section('newspaper_magazine_blog_blog_option',array(
        'title' => __('TP Blog Option', 'newspaper-magazine-blog'),
        'priority' => 1,
        'panel' => 'newspaper_magazine_blog_panel_id'
    ) );

    $wp_customize->add_setting('newspaper_magazine_blog_edit_blog_page_title',array(
		'default'=> __('Home','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_blog_page_title',array(
		'label'	=> __('Change Blog Page Title','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_edit_blog_page_description',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_blog_page_description',array(
		'label'	=> __('Add Blog Page Description','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_blog_option',
		'type'=> 'text'
	));

	/** Meta Order */
    $wp_customize->add_setting('blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_sortable',
    ));
    $wp_customize->add_control(new newspaper_magazine_blog_Control_Sortable($wp_customize, 'blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'newspaper-magazine-blog'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'newspaper-magazine-blog') ,
        'section' => 'newspaper_magazine_blog_blog_option',
        'choices' => array(
            'date' => __('date', 'newspaper-magazine-blog') ,
            'author' => __('author', 'newspaper-magazine-blog') ,
            'comment' => __('comment', 'newspaper-magazine-blog') ,
            'category' => __('category', 'newspaper-magazine-blog') ,
            'time' => __('time', 'newspaper-magazine-blog') ,
        ) ,
    )));

    $wp_customize->add_setting( 'newspaper_magazine_blog_excerpt_count', array(
		'default'              => 35,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'newspaper_magazine_blog_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'newspaper_magazine_blog_excerpt_count', array(
		'label'       => esc_html__( 'Edit Excerpt Limit','newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_show_first_caps',array(
        'default' => false,
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
    ));
	$wp_customize->add_control( 'newspaper_magazine_blog_show_first_caps',array(
		'label' => esc_html__('First Cap (First Capital Letter)', 'newspaper-magazine-blog'),
		'type' => 'checkbox',
		'section' => 'newspaper_magazine_blog_blog_option',
	));

    $wp_customize->add_setting('newspaper_magazine_blog_read_more_text',array(
		'default'=> __('Read More','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_read_more_text',array(
		'label'	=> __('Edit Button Text','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_post_image_round', array(
	  'default' => '0',
      'sanitize_callback' => 'newspaper_magazine_blog_sanitize_number_range',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Range_Slider($wp_customize, 'newspaper_magazine_blog_post_image_round', array(
       'section' => 'newspaper_magazine_blog_blog_option',
      'label' => esc_html__('Edit Post Image Border Radius', 'newspaper-magazine-blog'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 180,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_post_image_width', array(
	  'default' => '',
      'sanitize_callback' => 'newspaper_magazine_blog_sanitize_number_range',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Range_Slider($wp_customize, 'newspaper_magazine_blog_post_image_width', array(
       'section' => 'newspaper_magazine_blog_blog_option',
      'label' => esc_html__('Edit Post Image Width', 'newspaper-magazine-blog'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 367,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_post_image_length', array(
	  'default' => '',
      'sanitize_callback' => 'newspaper_magazine_blog_sanitize_number_range',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Range_Slider($wp_customize, 'newspaper_magazine_blog_post_image_length', array(
       'section' => 'newspaper_magazine_blog_blog_option',
      'label' => esc_html__('Edit Post Image height', 'newspaper-magazine-blog'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 900,
        'step' => 1
    )
	)));
	
	$wp_customize->add_setting( 'newspaper_magazine_blog_remove_read_button', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_remove_read_button', array(
		'label'       => esc_html__( 'Show / Hide Read More Button', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_remove_read_button',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_remove_tags', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_remove_tags', array(
		'label'       => esc_html__( 'Show / Hide Tags Option', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_remove_tags',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_remove_category', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_remove_category', array(
		'label'       => esc_html__( 'Show / Hide Category Option', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_remove_category',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_remove_comment', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
 	) );

	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_remove_comment', array(
	 'label'       => esc_html__( 'Show / Hide Comment Form', 'newspaper-magazine-blog' ),
	 'section'     => 'newspaper_magazine_blog_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'newspaper_magazine_blog_remove_comment',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_remove_related_post', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
 	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_remove_related_post', array(
	 'label'       => esc_html__( 'Show / Hide Related Post', 'newspaper-magazine-blog' ),
	 'section'     => 'newspaper_magazine_blog_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'newspaper_magazine_blog_remove_related_post',
	) ) );

	$wp_customize->add_setting('newspaper_magazine_blog_related_post_heading',array(
		'default'=> __('Related Posts','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_related_post_heading',array(
		'label'	=> __('Edit Section Title','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_related_post_per_page', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'newspaper_magazine_blog_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'newspaper_magazine_blog_related_post_per_page', array(
		'label'       => esc_html__( 'Related Post Per Page','newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 3,
			'max'              => 9,
		),
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_related_post_per_columns', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'newspaper_magazine_blog_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'newspaper_magazine_blog_related_post_per_columns', array(
		'label'       => esc_html__( 'Related Post Per Row','newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_post_layout',array(
        'default' => 'image-content',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Layout', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_blog_option',
        'choices' => array(
            'image-content' => __('Media-Content','newspaper-magazine-blog'),
            'content-image' => __('Content-Media','newspaper-magazine-blog'),
        ),
	) );

	//TP Single Blog Option
	$wp_customize->add_section('newspaper_magazine_blog_single_blog_option',array(
        'title' => __('Single Post Option', 'newspaper-magazine-blog'),
        'priority' => 1,
        'panel' => 'newspaper_magazine_blog_panel_id'
    ) );

    /** Meta Order */
    $wp_customize->add_setting('newspaper_magazine_blog_single_blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_sortable',
    ));
    $wp_customize->add_control(new newspaper_magazine_blog_Control_Sortable($wp_customize, 'newspaper_magazine_blog_single_blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'newspaper-magazine-blog'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'newspaper-magazine-blog') ,
        'section' => 'newspaper_magazine_blog_single_blog_option',
        'choices' => array(
            'date' => __('date', 'newspaper-magazine-blog') ,
            'author' => __('author', 'newspaper-magazine-blog') ,
            'comment' => __('comment', 'newspaper-magazine-blog') ,
            'category' => __('category', 'newspaper-magazine-blog') ,
            'time' => __('time', 'newspaper-magazine-blog') ,
        ) ,
    )));

    $wp_customize->add_setting('newspaper_magazine_blog_single_post_date_icon',array(
		'default'	=> 'far fa-calendar-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_single_post_date_icon',array(
		'label'	=> __('Change Date Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_single_blog_option',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_single_post_author_icon',array(
		'default'	=> 'fas fa-user',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_single_post_author_icon',array(
		'label'	=> __('Change Author Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_single_blog_option',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_single_post_comment_icon',array(
		'default'	=> 'fas fa-comments',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_single_post_comment_icon',array(
		'label'	=> __('Change Comment Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_single_blog_option',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_single_post_category_icon',array(
		'default'	=> 'fas fa-list',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_single_post_category_icon',array(
		'label'	=> __('Change Category Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_single_blog_option',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_single_post_time_icon',array(
		'default'	=> 'fas fa-clock',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_single_post_time_icon',array(
		'label'	=> __('Change Time Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_single_blog_option',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));

	//MENU TYPOGRAPHY
	$wp_customize->add_section( 'newspaper_magazine_blog_menu_typography', array(
    	'title'      => __( 'Menu Typography', 'newspaper-magazine-blog' ),
    	'priority' => 2,
		'panel' => 'newspaper_magazine_blog_panel_id'
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_menu_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices',
	));
	$wp_customize->add_control(	'newspaper_magazine_blog_menu_font_family', array(
		'section' => 'newspaper_magazine_blog_menu_typography',
		'label'   => __('Menu Fonts', 'newspaper-magazine-blog'),
		'type'    => 'select',
		'choices' => $newspaper_magazine_blog_font_array,
	));

	$wp_customize->add_setting('newspaper_magazine_blog_menu_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_menu_font_weight',array(
     'type' => 'radio',
     'label'     => __('Font Weight', 'newspaper-magazine-blog'),
     'section' => 'newspaper_magazine_blog_menu_typography',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','newspaper-magazine-blog'),
         '200' => __('200','newspaper-magazine-blog'),
         '300' => __('300','newspaper-magazine-blog'),
         '400' => __('400','newspaper-magazine-blog'),
         '500' => __('500','newspaper-magazine-blog'),
         '600' => __('600','newspaper-magazine-blog'),
         '700' => __('700','newspaper-magazine-blog'),
         '800' => __('800','newspaper-magazine-blog'),
         '900' => __('900','newspaper-magazine-blog')
     ),
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_menu_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
 	));
 	$wp_customize->add_control('newspaper_magazine_blog_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','newspaper-magazine-blog'),
		'section' => 'newspaper_magazine_blog_menu_typography',
		'choices' => array(
		   'Uppercase' => __('Uppercase','newspaper-magazine-blog'),
		   'Lowercase' => __('Lowercase','newspaper-magazine-blog'),
		   'Capitalize' => __('Capitalize','newspaper-magazine-blog'),
		),
	) );
	$wp_customize->add_setting('newspaper_magazine_blog_menu_font_size', array(
	  'default' => '',
      'sanitize_callback' => 'newspaper_magazine_blog_sanitize_number_range',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Range_Slider($wp_customize, 'newspaper_magazine_blog_menu_font_size', array(
        'section' => 'newspaper_magazine_blog_menu_typography',
        'label' => esc_html__('Font Size', 'newspaper-magazine-blog'),
        'input_attrs' => array(
          'min' => 0,
          'max' => 20,
          'step' => 1
    )
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_menus_item_style',array(
		'default' => '',
		'transport' => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_menus_item_style',array(
		'type' => 'select',
		'section' => 'newspaper_magazine_blog_menu_typography',
		'label' => __('Menu Hover Effect','newspaper-magazine-blog'),
		'choices' => array(
			'None' => __('None','newspaper-magazine-blog'),
			'Zoom In' => __('Zoom In','newspaper-magazine-blog'),
		),
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_menu_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_menu_color', array(
			'label'     => __('Change Menu Color', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_menu_typography',
	    'settings' => 'newspaper_magazine_blog_menu_color',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_menu_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_menu_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_menu_typography',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// Top Bar
	$wp_customize->add_section( 'newspaper_magazine_blog_topbar', array(
    	'title'      => __( 'Header Details', 'newspaper-magazine-blog' ),
    	'priority' => 2,
    	'description' => __( 'Add your contact details', 'newspaper-magazine-blog' ),
		'panel' => 'newspaper_magazine_blog_panel_id'
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_topbar_visibility', array(
	    'default'           => true, 
	    'transport'         => 'refresh',
	    'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Toggle_Control($wp_customize, 'newspaper_magazine_blog_topbar_visibility', array(
	    'label'       => esc_html__('Show / Hide Topbar', 'newspaper-magazine-blog'),
	    'section'     => 'newspaper_magazine_blog_topbar',
	    'type'        => 'toggle',
	    'settings'    => 'newspaper_magazine_blog_topbar_visibility',
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_query_text',array(
		'default'	=>  __('Have any question?','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_query_text',array(
		'label'	=> __('Change Have any question? Text','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_topbar',
		'type'		=> 'text'
	));
	
	$wp_customize->add_setting('newspaper_magazine_blog_query_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('newspaper_magazine_blog_query_link',array(
		'label'	=> __('Add Have any question? Link','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_topbar',
		'type'		=> 'url'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_mail',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_email'
	));
	$wp_customize->add_control('newspaper_magazine_blog_mail',array(
		'label'	=> __('Add Mail Address','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_call',array(
		'default'=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_phone_number'
	));
	$wp_customize->add_control('newspaper_magazine_blog_call',array(
		'label'	=> __('Add Phone Number','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_cart_language_translator', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_cart_language_translator', array(
		'label'       => esc_html__( 'Show / Hide Language Translator', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_topbar',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_cart_language_translator',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_currency_switcher', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_currency_switcher', array(
		'label'       => esc_html__( 'Show / Hide Currency Switcher', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_topbar',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_currency_switcher',
	) ) );

	$wp_customize->add_setting('newspaper_magazine_blog_interactive_globe_symbol',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('newspaper_magazine_blog_interactive_globe_symbol',array(
		'label'	=> esc_html__('Add globe with interaction link','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_topbar',
		'type'=> 'url'
	));

	// Subscribe
	$wp_customize->add_setting('newspaper_magazine_blog_subscribe_text',array(
		'default'	=> __('Subscribe','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_subscribe_text',array(
		'label'	=> __('Change Subscribe Button Text','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_topbar',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_subscribe_link',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('newspaper_magazine_blog_subscribe_link',array(
		'label'	=> __('Add Subscribe Button Link','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_topbar',
		'type'		=> 'url'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_sign_in_text',array(
		'default'=> __('Sign in','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sign_in_text',array(
		'label'	=> __('Add Sign In Button Text','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_topbar',
		'type'=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_sign_in_link',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sign_in_link',array(
		'label'	=> __('Add Sign In Button Link','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_topbar',
		'type'=> 'url'
	));

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_header_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_header_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_topbar',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// ---------slider section-----------//

	$wp_customize->add_section('newspaper_magazine_blog_slider_section', array(
	    'priority'       => 3,
	    'capability'     => 'edit_theme_options',
	    'title'          => __('Our Blog Post Section', 'newspaper-magazine-blog'),
	    'panel'          => 'newspaper_magazine_blog_panel_id',
	));

	// Enable/disable section
	$wp_customize->add_setting('newspaper_magazine_blog_slider_section_show', array(
	    'capability'        => 'edit_theme_options',
	    'default'           => true,
	    'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	));

	$wp_customize->add_control('newspaper_magazine_blog_slider_section_show', array(
	    'label'    => __('Enable Our Projects Section', 'newspaper-magazine-blog'),
	    'section'  => 'newspaper_magazine_blog_slider_section',
	    'type'     => 'checkbox',
	));

	// Number of tabs
	$wp_customize->add_setting('newspaper_magazine_blog_projetcs_number', array(
	    'default'           => 7,
	    'sanitize_callback' => 'absint',
	));

	$wp_customize->add_control('newspaper_magazine_blog_projetcs_number', array(
	    'label'       => esc_html__('No of Tabs to show', 'newspaper-magazine-blog'),
	    'section'     => 'newspaper_magazine_blog_slider_section',
	    'type'        => 'number',
	    'input_attrs' => array(
	        'step' => 1,
	        'min'  => 0,
	        'max'  => 14,
	    ),
	));

	// Dynamically adding tabs
	$featured_post = absint(get_theme_mod('newspaper_magazine_blog_projetcs_number', 7));
	for ( $j = 1; $j <= $featured_post; $j++ ) {
	    $wp_customize->add_setting('newspaper_magazine_blog_projetcs_text'.$j, array(
		    'default'           => '',
		    'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control('newspaper_magazine_blog_projetcs_text'.$j, array(
		    'label'   => esc_html__('Edit Tab Text ', 'newspaper-magazine-blog').$j, 
		    'section' => 'newspaper_magazine_blog_slider_section',
		    'type'    => 'text',
		));

		$wp_customize->add_setting('newspaper_magazine_blog_project_tab_image' . $j, array(
		    'default'           => '',
		    'sanitize_callback' => 'esc_url_raw',
		));
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'newspaper_magazine_blog_project_tab_image' . $j, array(
		    'label'   => esc_html__('Tab Background Image ', 'newspaper-magazine-blog') . $j,
		    'section' => 'newspaper_magazine_blog_slider_section',
		    'settings'=> 'newspaper_magazine_blog_project_tab_image' . $j,
		)));

	    $categories = get_categories();
	    $cat_posts = array('select' => 'Select');
	    foreach ($categories as $category) {
	        $cat_posts[$category->slug] = $category->name;
	    }

	    $wp_customize->add_setting('newspaper_magazine_blog_projetcs_category'.$j, array(
	        'default'           => '',
	        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices',
	    ));
	    $wp_customize->add_control('newspaper_magazine_blog_projetcs_category'.$j, array(
	        'type'    => 'select',
	        'choices' => $cat_posts,
	        'label'   => __('Select Category to display projects', 'newspaper-magazine-blog'),
	        'section' => 'newspaper_magazine_blog_slider_section',
	    ));
	}

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_slider_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_slider_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_slider_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	// Service Section Settings
	$wp_customize->add_section('newspaper_magazine_blog_service_section', array(
	  'title' => __('Our Category Section', 'newspaper-magazine-blog'),
	  'panel' => 'newspaper_magazine_blog_panel_id',
	  'priority' => 4,
	));

	$wp_customize->add_setting('newspaper_magazine_blog_show_hide_sec', array(
	  'default' => true,
	  'transport' => 'refresh',
	  'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Toggle_Control($wp_customize, 'newspaper_magazine_blog_show_hide_sec', array(
	  'label' => esc_html__('Show / Hide Service Section', 'newspaper-magazine-blog'),
	  'section' => 'newspaper_magazine_blog_service_section',
	  'type' => 'toggle',
	  'settings' => 'newspaper_magazine_blog_show_hide_sec',
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_featured_section_title', array(
	  'default' => '',
	  'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_featured_section_title', array(
	  'label' => __('Add Heading', 'newspaper-magazine-blog'),
	  'section' => 'newspaper_magazine_blog_service_section',
	  'type' => 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_product_section_btn_text1',array(
		'default'=> 'View All',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_product_section_btn_text1',array(
		'label'	=> esc_html__('Add Button Text','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_service_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_product_section_btn_link1',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('newspaper_magazine_blog_product_section_btn_link1',array(
		'label'	=> esc_html__('Add Button link','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_service_section',
		'type'=> 'url'
	));

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_about_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_about_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_service_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
    )));

	//footer
	$wp_customize->add_section('newspaper_magazine_blog_footer_section',array(
		'title'	=> __('Footer Widget Settings','newspaper-magazine-blog'),
		'panel' => 'newspaper_magazine_blog_panel_id',
		'priority' => 4,
	));

	$wp_customize->add_setting('newspaper_magazine_blog_footer_columns',array(
		'default'	=> 4,
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_columns',array(
		'label'	=> __('Footer Widget Columns','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_footer_section',
		'setting'	=> 'newspaper_magazine_blog_footer_columns',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	));
	$wp_customize->add_setting( 'newspaper_magazine_blog_tp_footer_bg_color_option', array(
		'default' => '#151515',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_tp_footer_bg_color_option', array(
		'label'     => __('Footer Widget Background Color', 'newspaper-magazine-blog'),
		'description' => __('It will change the complete footer widget backgorund color.', 'newspaper-magazine-blog'),
		'section' => 'newspaper_magazine_blog_footer_section',
		'settings' => 'newspaper_magazine_blog_tp_footer_bg_color_option',
	)));

	$wp_customize->add_setting('newspaper_magazine_blog_footer_widget_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'newspaper_magazine_blog_footer_widget_image',array(
       'label' => __('Footer Widget Background Image','newspaper-magazine-blog'),
       'section' => 'newspaper_magazine_blog_footer_section'
	)));

	//footer widget title font size
	$wp_customize->add_setting('newspaper_magazine_blog_footer_widget_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_widget_title_font_size',array(
		'label'	=> __('Change Footer Widget Title Font Size in PX','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_footer_section',
	    'setting'	=> 'newspaper_magazine_blog_footer_widget_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_footer_widget_title_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_footer_widget_title_color', array(
			'label'     => __('Change Footer Widget Title Color', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_footer_section',
	    'settings' => 'newspaper_magazine_blog_footer_widget_title_color',
  	)));

  	$wp_customize->add_setting('newspaper_magazine_blog_footer_widget_title_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_widget_title_font_weight',array(
     'type' => 'radio',
     'label'     => __('Change Footer Widget Title Font Weight', 'newspaper-magazine-blog'),
     'section' => 'newspaper_magazine_blog_footer_section',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','newspaper-magazine-blog'),
         '200' => __('200','newspaper-magazine-blog'),
         '300' => __('300','newspaper-magazine-blog'),
         '400' => __('400','newspaper-magazine-blog'),
         '500' => __('500','newspaper-magazine-blog'),
         '600' => __('600','newspaper-magazine-blog'),
         '700' => __('700','newspaper-magazine-blog'),
         '800' => __('800','newspaper-magazine-blog'),
         '900' => __('900','newspaper-magazine-blog')
     ),
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_footer_widget_title_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
 	));
 	$wp_customize->add_control('newspaper_magazine_blog_footer_widget_title_text_tranform',array(
		'type' => 'select',
		'label' => __('Change Footer Widget Title Letter Case','newspaper-magazine-blog'),
		'section' => 'newspaper_magazine_blog_footer_section',
		'choices' => array(
		   'Uppercase' => __('Uppercase','newspaper-magazine-blog'),
		   'Lowercase' => __('Lowercase','newspaper-magazine-blog'),
		   'Capitalize' => __('Capitalize','newspaper-magazine-blog'),
		),
	) );

	// Add Settings and Controls for position
	$wp_customize->add_setting('newspaper_magazine_blog_footer_widget_title_position',array(
        'default' => '',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_widget_title_position',array(
        'type' => 'radio',
        'label'     => __('Change Footer Widget Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for Footer Widget', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_footer_section',
        'choices' => array(
            'Right' => __('Right','newspaper-magazine-blog'),
            'Left' => __('Left','newspaper-magazine-blog'),
            'Center' => __('Center','newspaper-magazine-blog')
        ),
	) );
  	
	$wp_customize->add_setting( 'newspaper_magazine_blog_return_to_header', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_return_to_header', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_footer_section',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_return_to_header',
	) ) );

	$wp_customize->add_setting('newspaper_magazine_blog_return_icon',array(
		'default'	=> 'fas fa-arrow-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Newspaper_Magazine_Blog_Icon_Changer(
       $wp_customize,'newspaper_magazine_blog_return_icon',array(
		'label'	=> __('Return to header Icon','newspaper-magazine-blog'),
		'transport' => 'refresh',
		'section'	=> 'newspaper_magazine_blog_footer_section',
		'type'		=> 'newspaper-magazine-blog-icon'
	)));


    // Add Settings and Controls for Scroll top
	$wp_customize->add_setting('newspaper_magazine_blog_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_scroll_top_position',array(
        'type' => 'radio',
        'label'     => __('Scroll to top Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for scroll to top', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_footer_section',
        'choices' => array(
            'Right' => __('Right','newspaper-magazine-blog'),
            'Left' => __('Left','newspaper-magazine-blog'),
            'Center' => __('Center','newspaper-magazine-blog')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_footer_widget_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_footer_widget_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//footer
	$wp_customize->add_section('newspaper_magazine_blog_footer_copyright_section',array(
		'title'	=> __('Footer Copyright Settings','newspaper-magazine-blog'),
		'description'	=> __('Add copyright text.','newspaper-magazine-blog'),
		'panel' => 'newspaper_magazine_blog_panel_id',
		'priority' => 5,
	));

	$wp_customize->add_setting('newspaper_magazine_blog_footer_text',array(
		'default' => __( 'Newspaper Magazine Blog WordPress Theme', 'newspaper-magazine-blog' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_text',array(
		'label'	=> __('Copyright Text','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_footer_copyright_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_footer_copyright_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_copyright_font_size',array(
		'label'	=> __('Change Footer Copyright Font Size in PX','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_footer_copyright_section',
	    'setting'	=> 'newspaper_magazine_blog_footer_copyright_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_footer_copyright_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_footer_copyright_text_color', array(
			'label'     => __('Change Footer Copyright Text Color', 'newspaper-magazine-blog'),
	    'section' => 'newspaper_magazine_blog_footer_copyright_section',
	    'settings' => 'newspaper_magazine_blog_footer_copyright_text_color',
  	)));

  	$wp_customize->add_setting('newspaper_magazine_blog_footer_copyright_top_bottom_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_footer_copyright_top_bottom_padding',array(
		'label'	=> __('Change Footer Copyright Padding in PX','newspaper-magazine-blog'),
		'section'	=> 'newspaper_magazine_blog_footer_copyright_section',
	    'setting'	=> 'newspaper_magazine_blog_footer_copyright_top_bottom_padding',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// Add Settings and Controls for Scroll top
	$wp_customize->add_setting('newspaper_magazine_blog_copyright_text_position',array(
        'default' => 'Center',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_copyright_text_position',array(
        'type' => 'radio',
        'label'     => __('Copyright Text Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for Copyright', 'newspaper-magazine-blog'),
        'section' => 'newspaper_magazine_blog_footer_copyright_section',
        'choices' => array(
            'Right' => __('Right','newspaper-magazine-blog'),
            'Left' => __('Left','newspaper-magazine-blog'),
            'Center' => __('Center','newspaper-magazine-blog')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_copyright_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_copyright_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_footer_copyright_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//Mobile resposnsive
	$wp_customize->add_section('newspaper_magazine_blog_mobile_media_option',array(
		'title'         => __('Mobile Responsive media', 'newspaper-magazine-blog'),
		'description' => __('Control will not function if the toggle in the main settings is off.', 'newspaper-magazine-blog'),
		'priority' => 5,
		'panel' => 'newspaper_magazine_blog_panel_id'
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_mobile_blog_description', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_mobile_blog_description', array(
		'label'       => esc_html__( 'Show / Hide Blog Page Description', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_mobile_blog_description',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_return_to_header_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_return_to_header_mob', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_return_to_header_mob',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_slider_buttom_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_slider_buttom_mob', array(
		'label'       => esc_html__( 'Show / Hide Slider Button', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_slider_buttom_mob',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_related_post_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_related_post_mob', array(
		'label'       => esc_html__( 'Show / Hide Related Post', 'newspaper-magazine-blog' ),
		'section'     => 'newspaper_magazine_blog_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_related_post_mob',
	) ) );

	// Pro Version
    $wp_customize->add_setting( 'newspaper_magazine_blog_responsive_pro_version_logo', array(
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_custom_control'
    ));
    $wp_customize->add_control( new newspaper_magazine_blog_Customize_Pro_Version ( $wp_customize,'newspaper_magazine_blog_responsive_pro_version_logo', array(
        'section'     => 'newspaper_magazine_blog_mobile_media_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'newspaper-magazine-blog' ),
        'description' => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL ),
        'priority'    => 100
    )));
	
	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';

	//site Title
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'Newspaper_Magazine_Blog_Customize_partial_blogname',
	) );

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'Newspaper_Magazine_Blog_Customize_partial_blogdescription',
	) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_site_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_site_title', array(
		'label'       => esc_html__( 'Show / Hide Site Title', 'newspaper-magazine-blog' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_site_title',
	) ) );

	// logo site title size
	$wp_customize->add_setting('newspaper_magazine_blog_site_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_site_title_font_size',array(
		'label'	=> __('Site Title Font Size in PX','newspaper-magazine-blog'),
		'section'	=> 'title_tagline',
		'setting'	=> 'newspaper_magazine_blog_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
		    'step'             => 1,
			'min'              => 0,
			'max'              => 30,
			),
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_site_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_site_tagline_color', array(
			'label'     => __('Change Site Title Color', 'newspaper-magazine-blog'),
	    'section' => 'title_tagline',
	    'settings' => 'newspaper_magazine_blog_site_tagline_color',
  	)));

	$wp_customize->add_setting( 'newspaper_magazine_blog_site_tagline', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_site_tagline', array(
		'label'       => esc_html__( 'Show / Hide Site Tagline', 'newspaper-magazine-blog' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_site_tagline',
	) ) );

	// logo site tagline size
	$wp_customize->add_setting('newspaper_magazine_blog_site_tagline_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size in PX','newspaper-magazine-blog'),
		'section'	=> 'title_tagline',
		'setting'	=> 'newspaper_magazine_blog_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 30,
		),
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_logo_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_logo_tagline_color', array(
			'label'     => __('Change Site Tagline Color', 'newspaper-magazine-blog'),
	    'section' => 'title_tagline',
	    'settings' => 'newspaper_magazine_blog_logo_tagline_color',
  	)));

    $wp_customize->add_setting('newspaper_magazine_blog_logo_width',array(
	   'default' => 80,
	   'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_logo_width',array(
		'label'	=> esc_html__('Here You Can Customize Your Logo Size','newspaper-magazine-blog'),
		'section'	=> 'title_tagline',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_per_columns',array(
		'default'=> 3,
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_per_columns',array(
		'label'	=> __('Product Per Row','newspaper-magazine-blog'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting('newspaper_magazine_blog_product_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'newspaper_magazine_blog_sanitize_number_absint'
	));
	$wp_customize->add_control('newspaper_magazine_blog_product_per_page',array(
		'label'	=> __('Product Per Page','newspaper-magazine-blog'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'newspaper_magazine_blog_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Shop Page Sidebar', 'newspaper-magazine-blog' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_product_sidebar',
	) ) );
	$wp_customize->add_setting('newspaper_magazine_blog_sale_tag_position',array(
        'default' => 'right',
        'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
	$wp_customize->add_control('newspaper_magazine_blog_sale_tag_position',array(
        'type' => 'radio',
        'label'     => __('Sale Badge Position', 'newspaper-magazine-blog'),
        'description'   => __('This option work for Archieve Products', 'newspaper-magazine-blog'),
        'section' => 'woocommerce_product_catalog',
        'choices' => array(
            'left' => __('Left','newspaper-magazine-blog'),
            'right' => __('Right','newspaper-magazine-blog'),
        ),
	) );
	$wp_customize->add_setting( 'newspaper_magazine_blog_single_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_single_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Product Page Sidebar', 'newspaper-magazine-blog' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_single_product_sidebar',
	) ) );

	$wp_customize->add_setting( 'newspaper_magazine_blog_related_product', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_related_product', array(
		'label'       => esc_html__( 'Show / Hide related product', 'newspaper-magazine-blog' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'newspaper_magazine_blog_related_product',
	) ) );

	
	//Page template settings
	$wp_customize->add_panel( 'newspaper_magazine_blog_page_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Page Template Settings', 'newspaper-magazine-blog' ),
	    'description' => __( 'Description of what this panel does.', 'newspaper-magazine-blog' ),
	) );

	// 404 PAGE
	$wp_customize->add_section('newspaper_magazine_blog_404_page_section',array(
		'title'         => __('404 Page', 'newspaper-magazine-blog'),
		'description'   => __('Here you can customize 404 Page content.', 'newspaper-magazine-blog'),
		'panel' => 'newspaper_magazine_blog_page_panel_id'
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_edit_404_title',array(
		'default'=> __('Oops! That page cant be found.','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_404_title',array(
		'label'	=> __('Edit Title','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_404_page_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('newspaper_magazine_blog_edit_404_text',array(
		'default'=> __('It looks like nothing was found at this location. Maybe try a search?','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_404_text',array(
		'label'	=> __('Edit Text','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_404_page_section',
		'type'=> 'text'
	));

	// Search Results
	$wp_customize->add_section('newspaper_magazine_blog_no_result_section',array(
		'title'         => __('Search Results', 'newspaper-magazine-blog'),
		'description'  => __('Here you can customize Search Result content.', 'newspaper-magazine-blog'),
		'panel' => 'newspaper_magazine_blog_page_panel_id'
	) );

	$wp_customize->add_setting('newspaper_magazine_blog_edit_no_result_title',array(
		'default'=> __('Nothing Found','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_no_result_title',array(
		'label'	=> __('Edit Title','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_no_result_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('newspaper_magazine_blog_edit_no_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','newspaper-magazine-blog'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('newspaper_magazine_blog_edit_no_result_text',array(
		'label'	=> __('Edit Text','newspaper-magazine-blog'),
		'section'=> 'newspaper_magazine_blog_no_result_section',
		'type'=> 'text'
	));

	 // Header Image Height
    $wp_customize->add_setting(
        'newspaper_magazine_blog_header_image_height',
        array(
            'default'           => 500,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'newspaper_magazine_blog_header_image_height',
        array(
            'label'       => esc_html__( 'Header Image Height', 'newspaper-magazine-blog' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the height of the header image. Default is 350px.', 'newspaper-magazine-blog' ),
            'input_attrs' => array(
                'min'  => 220,
                'max'  => 1000,
                'step' => 1,
            ),
        )
    );

    // Header Background Position
    $wp_customize->add_setting(
        'newspaper_magazine_blog_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'newspaper_magazine_blog_header_background_position',
        array(
            'label'       => esc_html__( 'Header Background Position', 'newspaper-magazine-blog' ),
            'section'     => 'header_image',
            'type'        => 'select',
            'choices'     => array(
                'top'    => esc_html__( 'Top', 'newspaper-magazine-blog' ),
                'center' => esc_html__( 'Center', 'newspaper-magazine-blog' ),
                'bottom' => esc_html__( 'Bottom', 'newspaper-magazine-blog' ),
            ),
            'description' => esc_html__( 'Choose how you want to position the header image.', 'newspaper-magazine-blog' ),
        )
    );

    // Header Image Parallax Effect
    $wp_customize->add_setting(
        'newspaper_magazine_blog_header_background_attachment',
        array(
            'default'           => 1,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'newspaper_magazine_blog_header_background_attachment',
        array(
            'label'       => esc_html__( 'Header Image Parallax', 'newspaper-magazine-blog' ),
            'section'     => 'header_image',
            'type'        => 'checkbox',
            'description' => esc_html__( 'Add a parallax effect on page scroll.', 'newspaper-magazine-blog' ),
        )
    );

        //Opacity
	$wp_customize->add_setting('newspaper_magazine_blog_header_banner_opacity_color',array(
       'default'              => '0.5',
       'sanitize_callback' => 'newspaper_magazine_blog_sanitize_choices'
	));
    $wp_customize->add_control( 'newspaper_magazine_blog_header_banner_opacity_color', array(
		'label'       => esc_html__( 'Header Image Opacity','newspaper-magazine-blog' ),
		'section'     => 'header_image',
		'type'        => 'select',
		'settings'    => 'newspaper_magazine_blog_header_banner_opacity_color',
		'choices' => array(
           '0' =>  esc_attr(__('0','newspaper-magazine-blog')),
           '0.1' =>  esc_attr(__('0.1','newspaper-magazine-blog')),
           '0.2' =>  esc_attr(__('0.2','newspaper-magazine-blog')),
           '0.3' =>  esc_attr(__('0.3','newspaper-magazine-blog')),
           '0.4' =>  esc_attr(__('0.4','newspaper-magazine-blog')),
           '0.5' =>  esc_attr(__('0.5','newspaper-magazine-blog')),
           '0.6' =>  esc_attr(__('0.6','newspaper-magazine-blog')),
           '0.7' =>  esc_attr(__('0.7','newspaper-magazine-blog')),
           '0.8' =>  esc_attr(__('0.8','newspaper-magazine-blog')),
           '0.9' =>  esc_attr(__('0.9','newspaper-magazine-blog'))
		), 
	) );

   $wp_customize->add_setting( 'newspaper_magazine_blog_header_banner_image_overlay', array(
	    'default'   => true,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'newspaper_magazine_blog_sanitize_checkbox',
	));
	$wp_customize->add_control( new Newspaper_Magazine_Blog_Toggle_Control( $wp_customize, 'newspaper_magazine_blog_header_banner_image_overlay', array(
	    'label'   => esc_html__( 'Show / Hide Header Image Overlay', 'newspaper-magazine-blog' ),
	    'section' => 'header_image',
	)));

    $wp_customize->add_setting('newspaper_magazine_blog_header_banner_image_ooverlay_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'newspaper_magazine_blog_header_banner_image_ooverlay_color', array(
		'label'    => __('Header Image Overlay Color', 'newspaper-magazine-blog'),
		'section'  => 'header_image',
	)));

    $wp_customize->add_setting(
        'newspaper_magazine_blog_header_image_title_font_size',
        array(
            'default'           => 40,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'newspaper_magazine_blog_header_image_title_font_size',
        array(
            'label'       => esc_html__( 'Change Header Image Title Font Size', 'newspaper-magazine-blog' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the font Size of the header image title. Default is 40px.', 'newspaper-magazine-blog' ),
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 200,
                'step' => 1,
            ),
        )
    );

	$wp_customize->add_setting( 'newspaper_magazine_blog_header_image_title_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'newspaper_magazine_blog_header_image_title_text_color', array(
			'label'     => __('Change Header Image Title Color', 'newspaper-magazine-blog'),
	    'section' => 'header_image',
	    'settings' => 'newspaper_magazine_blog_header_image_title_text_color',
  	)));

}
add_action( 'customize_register', 'Newspaper_Magazine_Blog_Customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since Newspaper Magazine Blog 1.0
 * @see Newspaper_Magazine_Blog_Customize_register()
 *
 * @return void
 */
function Newspaper_Magazine_Blog_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Newspaper Magazine Blog 1.0
 * @see Newspaper_Magazine_Blog_Customize_register()
 *
 * @return void
 */
function Newspaper_Magazine_Blog_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if ( ! defined( 'NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_NAME' ) ) {
	define( 'NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_NAME', esc_html__( 'Magazine Blog Pro', 'newspaper-magazine-blog'));
}
if ( ! defined( 'NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL' ) ) {
	define( 'NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL', esc_url('https://www.themespride.com/products/newspaper-magazine-wordpress-theme', 'newspaper-magazine-blog'));
}


if ( ! defined( 'NEWSPAPER_MAGAZINE_BLOG_DOCS_URL' ) ) {
	define( 'NEWSPAPER_MAGAZINE_BLOG_DOCS_URL', esc_url('https://page.themespride.com/demo/docs/newspaper-magazine-blog-lite/'));
}
if ( ! defined( 'NEWSPAPER_MAGAZINE_BLOG_TEXT' ) ) {
    define( 'NEWSPAPER_MAGAZINE_BLOG_TEXT', __( 'Newspaper Magazine Blog Pro','newspaper-magazine-blog' ));
}
if ( ! defined( 'NEWSPAPER_MAGAZINE_BLOG_BUY_TEXT' ) ) {
    define( 'NEWSPAPER_MAGAZINE_BLOG_BUY_TEXT', __( 'Upgrade Pro','newspaper-magazine-blog' ));
}

add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( Newspaper_Magazine_Blog_Button::class );

    $manager->add_section(
        new Newspaper_Magazine_Blog_Button( $manager, 'newspaper_magazine_blog_pro', [
            'title'       => esc_html( NEWSPAPER_MAGAZINE_BLOG_TEXT,'newspaper-magazine-blog' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'newspaper-magazine-blog' ),
            'button_url'  => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL )
        ] )
    );

} );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Newspaper_Magazine_Blog_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Newspaper_Magazine_Blog_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Newspaper_Magazine_Blog_Customize_Section_Pro(
				$manager,
				'newspaper_magazine_blog_section_pro',
				array(
					'priority'   => 9,
					'title'    => NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_NAME,
					'pro_text' => esc_html__( 'Upgrade Pro', 'newspaper-magazine-blog' ),
					'pro_url'  => esc_url( NEWSPAPER_MAGAZINE_BLOG_PRO_THEME_URL, 'newspaper-magazine-blog' ),
				)
			)
		);

		// Register sections.
		$manager->add_section(
			new newspaper_magazine_blog_Customize_Section_Pro(
				$manager,
				'newspaper_magazine_blog_documentation',
				array(
					'priority'   => 500,
					'title'    => esc_html__( 'Theme Documentation', 'newspaper-magazine-blog' ),
					'pro_text' => esc_html__( 'Click Here', 'newspaper-magazine-blog' ),
					'pro_url'  => esc_url( NEWSPAPER_MAGAZINE_BLOG_DOCS_URL, 'newspaper-magazine-blog'),
				)
			)
		);

	}
	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'newspaper-magazine-blog-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'newspaper-magazine-blog-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Newspaper_Magazine_Blog_Customize::get_instance();