<?php
/**
 * Custom header implementation
 *
 * @link https://codex.wordpress.org/Custom_Headers
 *
 * @package Newspaper Magazine Blog
 * @subpackage newspaper_magazine_blog
 */

function newspaper_magazine_blog_custom_header_setup() {
    register_default_headers( array(
        'default-image' => array(
            'url'           => get_template_directory_uri() . '/assets/images/post-img2.png',
            'thumbnail_url' => get_template_directory_uri() . '/assets/images/post-img2.png',
            'description'   => __( 'Default Header Image', 'newspaper-magazine-blog' ),
        ),
    ) );
}
add_action( 'after_setup_theme', 'newspaper_magazine_blog_custom_header_setup' );

/**
 * Styles the header image based on Customizer settings.
 */
function newspaper_magazine_blog_header_style() {
    $newspaper_magazine_blog_header_image = get_header_image() ? get_header_image() : get_template_directory_uri() . '/assets/images/post-img2.png';

    $newspaper_magazine_blog_height     = get_theme_mod( 'newspaper_magazine_blog_header_image_height', 400 );
    $newspaper_magazine_blog_position   = get_theme_mod( 'newspaper_magazine_blog_header_background_position', 'center' );
    $newspaper_magazine_blog_attachment = get_theme_mod( 'newspaper_magazine_blog_header_background_attachment', 1 ) ? 'fixed' : 'scroll';

    $newspaper_magazine_blog_custom_css = "
        .header-img, .single-page-img, .external-div .box-image-page img, .external-div {
            background-image: url('" . esc_url( $newspaper_magazine_blog_header_image ) . "');
            background-size: cover;
            height: " . esc_attr( $newspaper_magazine_blog_height ) . "px;
            background-position: " . esc_attr( $newspaper_magazine_blog_position ) . ";
            background-attachment: " . esc_attr( $newspaper_magazine_blog_attachment ) . ";
        }

        @media (max-width: 1000px) {
            .header-img, .single-page-img, .external-div .box-image-page img,.external-div,.featured-image{
                height: 250px !important;
            }
            .box-text h2{
                font-size: 27px;
            }
        }
    ";

    wp_add_inline_style( 'newspaper-magazine-blog-style', $newspaper_magazine_blog_custom_css );
}
add_action( 'wp_enqueue_scripts', 'newspaper_magazine_blog_header_style' );

/**
 * Enqueue the main theme stylesheet.
 */
function newspaper_magazine_blog_enqueue_styles() {
    wp_enqueue_style( 'newspaper-magazine-blog-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'newspaper_magazine_blog_enqueue_styles' );