( function( window, document ) {
  function newspaper_magazine_blog_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const newspaper_magazine_blog_nav = document.querySelector( '.sidenav' );
      if ( ! newspaper_magazine_blog_nav || ! newspaper_magazine_blog_nav.classList.contains( 'open' ) ) {
        return;
      }
      const elements = [...newspaper_magazine_blog_nav.querySelectorAll( 'input, a, button' )],
        newspaper_magazine_blog_lastEl = elements[ elements.length - 1 ],
        newspaper_magazine_blog_firstEl = elements[0],
        newspaper_magazine_blog_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;
      if ( ! shiftKey && tabKey && newspaper_magazine_blog_lastEl === newspaper_magazine_blog_activeEl ) {
        e.preventDefault();
        newspaper_magazine_blog_firstEl.focus();
      }
      if ( shiftKey && tabKey && newspaper_magazine_blog_firstEl === newspaper_magazine_blog_activeEl ) {
        e.preventDefault();
        newspaper_magazine_blog_lastEl.focus();
      }
    } );
  }
  newspaper_magazine_blog_keepFocusInMenu();
} )( window, document );