<?php
/* ------------------------------------------------------------------------- *
 *  Dynamic styles
/* ------------------------------------------------------------------------- */

if (!function_exists('newspanda_get_inline_css')) :
    /**
     * Outputs theme custom CSS.
     *
     * @since 1.0.0
     */
    function newspanda_get_inline_css()
    {
        $defaults = newspanda_get_all_customizer_default_values();
        $background_color = get_theme_mod('background_color');

        $newspanda_site_logo_height = newspanda_get_option('newspanda_site_logo_height');

        ob_start();
        ?>
        <?php if (!empty($background_color) && $background_color != 'f5f5f5') :
        ?>
        :root {
        --wpi--base-bg-color: #<?php echo esc_attr($background_color); ?>;
        }
    <?php endif; ?>

        <?php if ($newspanda_site_logo_height !== $defaults['newspanda_site_logo_height']) : ?>
        .site-logo img {
        height:<?php echo absint($newspanda_site_logo_height); ?>px;
        }
    <?php endif; ?>
        <?php
        return ob_get_clean();
    }
endif;
