<?php

function newsosa_sanitize_select( $input, $setting ) {
	
	// Ensure input is a slug
	$input = sanitize_key( $input );
	
	// Get list of choices from the control
	// associated with the setting
	$choices = $setting->manager->get_control( $setting->id );
	
	// If the input is a valid key, return it;
	// otherwise, return the default
	return ( array_key_exists( $input, $choices->choices ) ? $input : $setting->default );
}



function newsosa_layout_customizer_settings( $wp_customize ){



	//INDEX POSTS STYLE
	$wp_customize->add_setting('newsosa_index_class_name_settings', array(
	    'default' => __('newsjolt-magazine-index', 'newsosa'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));

	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'newsosa_index_class_name_display_control', array(
	    'label'    => __('Newsosa - Change Style', 'newsosa'),
	    'section'  => 'newsjolt_magazine_index_class_name_section',
	    'settings' => 'newsosa_index_class_name_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-index' 		            => __('List Layout - Right Sidebar', 'newsosa'),
	    				'newsjolt-magazine-index-twenty-three' 		=> __('List (box shadow) - Two Columns Right Sidebar - Right Sidebar', 'newsosa'),
	    				'newsjolt-magazine-index-twenty-four' 		=> __('List (border) - Two Columns Right Sidebar - Right Sidebar', 'newsosa'),
	    			   )
	)));

	//CHANGE STYLE FEATURE SECTION
	$wp_customize->add_setting('newsosa_feature_change_style_settings', array(
	    'default' => __('newsjolt-magazine-feature-nineteen', 'newsosa'),
	    'sanitize_callback'  => 'sanitize_text_field',
	));


	$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'newsosa_feature_change_style_control', array(
	    'label'    => __('Newsosa - Change Style', 'newsosa'),
	    'section'  => 'newsjolt_magazine_feature_section',
	    'settings' => 'newsosa_feature_change_style_settings',
	    'type'     	=> 'select',
	    'choices'	=> array(
	    				'newsjolt-magazine-feature-nineteen' => __('Style 21 - ( Newsjolt Layout 3 Columns )', 'newsosa'),
	    				'newsjolt-magazine-feature-twenty-two' 		=> __('Style 22', 'newsosa'),
	    			   )
	)));




}


add_action('customize_register', 'newsosa_layout_customizer_settings');	