<?php
if (!function_exists('newsmode_banner_trending_posts')):
    /**
     *
     * @since Newsmode 1.0.0
     *
     */
    function newsmode_banner_trending_posts() { ?>
        <div class="col-md-3">
            <div class="trending-area mg-posts-sec-inner row">
                <div class="small-list-post col-lg-12">
                    <?php
                    if (is_front_page() || is_home()) {
                        $number_of_posts = '4';
                        $newsup_slider_category = newsup_get_option('select_trending_news_category');
                        $newsup_all_posts_main = newsup_get_posts($number_of_posts, $newsup_slider_category);
                        if ($newsup_all_posts_main->have_posts()) :
                            while ($newsup_all_posts_main->have_posts()) : $newsup_all_posts_main->the_post();
                            global $post;
                            $newsup_url = newsup_get_freatured_image_url($post->ID, 'newsup-slider-full');
                            ?>
                            <div class="small-post clearfix">
                                <!-- small_post -->
                    
                                <?php if (!empty($newsup_url)){ ?>
                                <div class="img-small-post">
                                    <a href="<?php the_permalink(); ?>">
                                        <img src="<?php echo esc_url($newsup_url); ?>" alt="<?php the_title(); ?>">
                                    </a>
                                    <!-- img-small-post -->
                                </div>
                                <!-- // img-small-post -->
                                <?php } ?>
                                <div class="small-post-content">
                                    <!-- small-post-content -->
                                    <div class="title_small_post">
                                        <h5 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                    </div>                                    
                                    <!-- // title_small_post -->
                                    <?php newsup_date_content(); ?>
                                </div>
                                <!-- // small-post-content -->
                            </div>
                            <?php
                            endwhile;
                        endif;
                        wp_reset_postdata();
                    }
                    ?>
                </div>
            </div>
        </div>
        <?php 
    }
endif;

add_action('newsmode_action_banner_trending_posts', 'newsmode_banner_trending_posts', 10);

if (!function_exists('newsmode_banner_recent_posts')):
    /**
     *
     * @since Newsmode 1.0.0
     *
     */
    function newsmode_banner_recent_posts() { ?>
        <div class="col-md-12">
            <div class="recent-posts">
            <?php
            if (is_front_page() || is_home()) {
                $number_of_posts = '5';
                $newsup_slider_category = newsup_get_option('select_recent_news_category');
                $newsup_all_posts_main = newsup_get_posts($number_of_posts, $newsup_slider_category);
                if ($newsup_all_posts_main->have_posts()) :
                    while ($newsup_all_posts_main->have_posts()) : $newsup_all_posts_main->the_post();
                    global $post;
                    $newsup_url = newsup_get_freatured_image_url($post->ID, 'newsup-slider-full');
                    ?>
                    <div class="mg-blog-post lg back-img" <?php if (!empty($newsup_url)): ?> style="background-image: url('<?php echo esc_url($newsup_url); ?>');"<?php endif; ?>>
                        <a class="link-div" href="<?php the_permalink(); ?>"> </a>
                        <article class="bottom">
                            <?php echo newsup_post_format_type($post);
                            newsup_post_categories(); ?> 
                            <h4 class="title"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                            <?php newsup_post_meta(); ?>
                        </article>
                    </div>    
                    <?php
                    endwhile;
                endif;
                wp_reset_postdata();
            }
            ?>
            </div>
        </div>
        <?php 
    }
endif;

add_action('newsmode_action_banner_recent_posts', 'newsmode_banner_recent_posts', 10);

//Front Page Banner
if (!function_exists('newsmode_front_page_banner_section')) :
    /**
     *
     * @since Newsup
     *
     */
    function newsmode_front_page_banner_section() {
        if (is_front_page() || is_home()) {
            
            do_action('newsup_action_banner_exclusive_posts'); 
            $newsup_enable_main_slider = newsup_get_option('show_main_news_section');
            $select_vertical_slider_news_category = newsup_get_option('select_vertical_slider_news_category');
            $vertical_slider_number_of_slides = newsup_get_option('vertical_slider_number_of_slides');
            $all_posts_vertical = newsup_get_posts($vertical_slider_number_of_slides, $select_vertical_slider_news_category);
            if ($newsup_enable_main_slider):  

                $main_banner_section_background_image = newsup_get_option('main_banner_section_background_image');
                $main_banner_section_background_image_url = wp_get_attachment_image_src($main_banner_section_background_image, 'full');
                if(!empty($main_banner_section_background_image)){ ?>
                    <section class="mg-fea-area over" style="background-image:url('<?php echo esc_url($main_banner_section_background_image_url[0]); ?>');">
                <?php }else{ ?>
                    <section class="mg-fea-area">
                <?php  } ?>
                    <div class="overlay">
                        <div class="container-fluid">
                            <div class="row">
                                <!-- <div class="col-md-6">
                                    <div id="homemain"class="homemain owl-carousel"> 
                                         newsup_get_block('list', 'banner'); ?>
                                    </div>
                                </div>  -->
                                <?php do_action('newsmode_action_banner_recent_posts');?>
                                <!--  do_action('newsmode_action_banner_trending_posts'); -->
                            </div>
                        </div>
                    </div>
                </section>
                <!--==/ Home Slider ==-->
            <?php endif; ?>
            <!-- end slider-section -->
        <?php }
    }
endif;
add_action('newsmode_action_front_page_main_section_1', 'newsmode_front_page_banner_section', 40);

if (!function_exists('newsmode_header_search_section')) :
/**
 *  Search
 *
 * @since Newsup
 *
 */
function newsmode_header_search_section() { 
    $header_search_enable = get_theme_mod('header_search_enable','true');
    if($header_search_enable == true) {
    ?>
    <div class="dropdown show mg-search-box pr-2">
        <a class="dropdown-toggle msearch ml-auto" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="fas fa-search"></i>
        </a>
        <div class="dropdown-menu searchinner" aria-labelledby="dropdownMenuLink">
            <?php get_search_form(); ?>
        </div>
    </div>
    <?php } 
}
endif;
add_action('newsmode_action_header_search_section', 'newsmode_header_search_section', 5);

if (!function_exists('newsmode_header_subscribe_section')) :
    /**
     *  Subscribe
     *
     * @since Newsup
     *
     */
    function newsmode_header_subscribe_section() { 
        $header_subsc_enable = get_theme_mod('header_subsc_enable','true');
        $subsc_target = get_theme_mod('newsup_subsc_link_target','true');
        $newsup_subsc_link = get_theme_mod('newsup_subsc_link','#');
        if($header_subsc_enable == true) {
        ?>
          <a href="<?php echo esc_url($newsup_subsc_link); ?>" <?php if($subsc_target) { ?> target="_blank" <?php } ?>  class="btn-bell btn-theme mx-2">
            <i class="fa fa-bell"></i>
        </a>
      <?php }
    }
endif;
add_action('newsmode_action_header_subscribe_section', 'newsmode_header_subscribe_section', 5);  