<?php

/**
 * Option Panel
 *
 * @package Newshike
 */


function newshike_customize_register($wp_customize) {

$newsup_default = newshike_get_default_theme_options();

$wp_customize->remove_control('newsup_select_slider_setting');
$wp_customize->remove_control('header_time_enable');

$wp_customize->get_setting('newsup_title_font_size')->default  = '46'; 
$wp_customize->get_setting('newsup_header_overlay_color')->default  = '#fff';
$wp_customize->get_setting('flash_news_title')->default  = $newsup_default['flash_news_title'] ;

$wp_customize->get_control('header_data_title')->label  = esc_html__('Date', 'newshike');
$wp_customize->get_control('header_data_title')->priority  = 1;

//section title
$wp_customize->add_setting('trending_post_section_title',
    array(
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    new newsup_Section_Title(
        $wp_customize,
        'trending_post_section_title',
        array(
            'label'             => esc_html__( 'Treanding Post Section', 'newshike' ),
            'section'           => 'frontpage_main_banner_section_settings',
            'priority'          => 100,
            'active_callback' => 'newsup_main_banner_section_status'
        )
    )
);
// Setting - drop down category for slider.
$wp_customize->add_setting('select_trending_news_category',
    array(
        'default' => $newsup_default['select_trending_news_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(new Newsup_Dropdown_Taxonomies_Control($wp_customize, 'select_trending_news_category',
    array(
        'label' => esc_html__('Category', 'newshike'),
        'description' => esc_html__('Posts to be shown on trending 4 Post', 'newshike'),
        'section' => 'frontpage_main_banner_section_settings',
        'type' => 'dropdown-taxonomies',
        'taxonomy' => 'category',
        'priority' => 100,
        'active_callback' => 'newsup_main_banner_section_status'
    )));
}
add_action('customize_register', 'newshike_customize_register');
