<?php
if ( ! get_theme_mod( 'newsbreak_magazine_enable_banner_section', false ) ) {
	return;
}

$banner_content_ids  = array();
$banner_content_type = get_theme_mod( 'newsbreak_magazine_banner_posts_content_type', 'post' );

if ( $banner_content_type === 'post' ) {
	for ( $i = 1; $i <= 3; $i++ ) {
		$banner_content_ids[] = get_theme_mod( 'newsbreak_magazine_banner_posts_content_post_' . $i );
	}
	$banner_posts_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $banner_content_ids ) ) ) {
		$banner_posts_args['post__in'] = array_filter( $banner_content_ids );
		$banner_posts_args['orderby']  = 'post__in';
	} else {
		$banner_posts_args['orderby'] = 'date';
	}
} else {
	$cat_content_id    = get_theme_mod( 'newsbreak_magazine_banner_posts_content_category' );
	$banner_posts_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}
$banner_posts_args = apply_filters( 'newsbreak_magazine_banner_section_args', $banner_posts_args );

newsbreak_magazine_render_banner_section( $banner_posts_args );

/**
 * Render Banner Section.
 */
function newsbreak_magazine_render_banner_section( $banner_posts_args ) {
	$section_title = get_theme_mod( 'newsbreak_magazine_banner_title', __( 'Main News', 'newsbreak-magazine' ) );
	$widget_class  = '';
	if ( is_active_sidebar( 'banner-widget-1' ) && is_active_sidebar( 'banner-widget-2' ) ) {
		$widget_class = 'two-banner-widgets';
	} elseif ( is_active_sidebar( 'banner-widget-1' ) || is_active_sidebar( 'banner-widget-2' ) ) {
		$widget_class = 'one-banner-widget';
	}
	?>

	<section id="newsbreak_magazine_banner_section" class="banner-section style-2">
		<?php
		if ( is_customize_preview() ) :
			newsbreak_magazine_section_link( 'newsbreak_magazine_banner_section' );
		endif;
		?>
		<div class="ascendoor-wrapper">
			<div class="banner-section-wrapper <?php echo esc_attr( $widget_class ); ?>">
				<?php if ( is_active_sidebar( 'banner-widget-1' ) ) { ?>
					<div class="banner-widget-area">
						<div class="banner-widget-inside">
							<?php dynamic_sidebar( 'banner-widget-1' ); ?>
						</div>
					</div>
				<?php } ?>
				<div class="banner-slider-section magazine-carousel-slider-navigation">
					<div class="section-header">
						<?php if ( ! empty( $section_title ) ) { ?>
							<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
						<?php } ?>	
						<div class="banner-slider-arrows magazine-carousel-slider-navigation banner-carousel-nav"></div>			
					</div>
					<div class="banner-slider-wrapper">
						<?php
						$banner_query = new WP_Query( $banner_posts_args );
						if ( $banner_query->have_posts() ) :
							while ( $banner_query->have_posts() ) :
								$banner_query->the_post();
								?>
								<div class="mag-post-single has-image tile-design">
									<?php if ( has_post_thumbnail() ) { ?>
										<div class="mag-post-img">
											<a href="<?php the_permalink(); ?>">
												<?php the_post_thumbnail( 'post-thumbnail' ); ?>
											</a>
										</div>
									<?php } ?>
									<div class="mag-post-detail">
										<div class="mag-post-category with-background">
											<?php newsbreak_magazine_categories_list( true ); ?>
										</div>
										<h3 class="mag-post-title">
											<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
										</h3>
										<div class="mag-post-meta">
											<span class="post-author">
												<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="fas fa-user"></i><?php echo esc_html( get_the_author() ); ?></a>
											</span>
											<span class="post-date">
												<a href="<?php the_permalink(); ?>"><i class="far fa-clock"></i><?php echo esc_html( get_the_date() ); ?></a>
											</span>
										</div>
									</div>
								</div>
								<?php
							endwhile;
							wp_reset_postdata();
						endif;
						?>
					</div>
				</div>
				<?php if ( is_active_sidebar( 'banner-widget-2' ) ) { ?>
					<div class="banner-widget-area">
						<div class="banner-widget-inside">
							<?php dynamic_sidebar( 'banner-widget-2' ); ?>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	</section>

	<?php
}
