<?php
/**
 * Typography
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_typography',
	array(
		'panel' => 'newsbreak_magazine_theme_options',
		'title' => esc_html__( 'Typography', 'newsbreak-magazine' ),
	)
);

// Typography - Site Title Font.
$wp_customize->add_setting(
	'newsbreak_magazine_site_title_font',
	array(
		'default'           => 'Titillium Web',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_site_title_font',
	array(
		'label'    => esc_html__( 'Site Title Font Family', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_typography',
		'settings' => 'newsbreak_magazine_site_title_font',
		'type'     => 'select',
		'choices'  => newsbreak_magazine_get_all_google_font_families(),
	)
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'newsbreak_magazine_site_description_font',
	array(
		'default'           => 'Titillium Web',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_typography',
		'settings' => 'newsbreak_magazine_site_description_font',
		'type'     => 'select',
		'choices'  => newsbreak_magazine_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'newsbreak_magazine_header_font',
	array(
		'default'           => 'Titillium Web',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_header_font',
	array(
		'label'    => esc_html__( 'Header Font Family', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_typography',
		'settings' => 'newsbreak_magazine_header_font',
		'type'     => 'select',
		'choices'  => newsbreak_magazine_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'newsbreak_magazine_body_font',
	array(
		'default'           => 'Titillium Web',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_body_font',
	array(
		'label'    => esc_html__( 'Body Font Family', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_typography',
		'settings' => 'newsbreak_magazine_body_font',
		'type'     => 'select',
		'choices'  => newsbreak_magazine_get_all_google_font_families(),
	)
);
