<?php
/**
 * Sidebar Position
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'newsbreak-magazine' ),
		'panel' => 'newsbreak_magazine_theme_options',
	)
);

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'newsbreak_magazine_sidebar_position',
	array(
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'newsbreak-magazine' ),
		'section' => 'newsbreak_magazine_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'newsbreak-magazine' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'newsbreak-magazine' ),
		),
	)
);

// Sidebar Position - Post Sidebar Position.
$wp_customize->add_setting(
	'newsbreak_magazine_post_sidebar_position',
	array(
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'newsbreak-magazine' ),
		'section' => 'newsbreak_magazine_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'newsbreak-magazine' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'newsbreak-magazine' ),
		),
	)
);

// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'newsbreak_magazine_page_sidebar_position',
	array(
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'newsbreak-magazine' ),
		'section' => 'newsbreak_magazine_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'newsbreak-magazine' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'newsbreak-magazine' ),
		),
	)
);
