<?php
/**
 * Post Options
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_post_options',
	array(
		'title' => esc_html__( 'Post Options', 'newsbreak-magazine' ),
		'panel' => 'newsbreak_magazine_theme_options',
	)
);

// Post Options - Hide Date.
$wp_customize->add_setting(
	'newsbreak_magazine_post_hide_date',
	array(
		'default'           => false,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_post_hide_date',
		array(
			'label'   => esc_html__( 'Hide Date', 'newsbreak-magazine' ),
			'section' => 'newsbreak_magazine_post_options',
		)
	)
);

// Post Options - Hide Author.
$wp_customize->add_setting(
	'newsbreak_magazine_post_hide_author',
	array(
		'default'           => false,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_post_hide_author',
		array(
			'label'   => esc_html__( 'Hide Author', 'newsbreak-magazine' ),
			'section' => 'newsbreak_magazine_post_options',
		)
	)
);

// Post Options - Hide Category.
$wp_customize->add_setting(
	'newsbreak_magazine_post_hide_category',
	array(
		'default'           => false,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_post_hide_category',
		array(
			'label'   => esc_html__( 'Hide Category', 'newsbreak-magazine' ),
			'section' => 'newsbreak_magazine_post_options',
		)
	)
);

// Post Options - Hide Tag.
$wp_customize->add_setting(
	'newsbreak_magazine_post_hide_tags',
	array(
		'default'           => false,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_post_hide_tags',
		array(
			'label'   => esc_html__( 'Hide Tag', 'newsbreak-magazine' ),
			'section' => 'newsbreak_magazine_post_options',
		)
	)
);

// Post Options - Related Post Label.
$wp_customize->add_setting(
	'newsbreak_magazine_post_related_post_label',
	array(
		'default'           => __( 'Related Posts', 'newsbreak-magazine' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_post_related_post_label',
	array(
		'label'    => esc_html__( 'Related Posts Label', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_post_options',
		'settings' => 'newsbreak_magazine_post_related_post_label',
		'type'     => 'text',
	)
);
