<?php
/**
 * Pagination
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_pagination',
	array(
		'panel' => 'newsbreak_magazine_theme_options',
		'title' => esc_html__( 'Pagination', 'newsbreak-magazine' ),
	)
);

// Pagination - Enable Pagination.
$wp_customize->add_setting(
	'newsbreak_magazine_enable_pagination',
	array(
		'default'           => true,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_enable_pagination',
		array(
			'label'    => esc_html__( 'Enable Pagination', 'newsbreak-magazine' ),
			'section'  => 'newsbreak_magazine_pagination',
			'settings' => 'newsbreak_magazine_enable_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Type.
$wp_customize->add_setting(
	'newsbreak_magazine_pagination_type',
	array(
		'default'           => 'default',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Type', 'newsbreak-magazine' ),
		'section'         => 'newsbreak_magazine_pagination',
		'settings'        => 'newsbreak_magazine_pagination_type',
		'active_callback' => 'newsbreak_magazine_is_pagination_enabled',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'newsbreak-magazine' ),
			'numeric' => __( 'Numeric', 'newsbreak-magazine' ),
		),
	)
);
