<?php
/**
 * Header Options
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_header_options',
	array(
		'panel' => 'newsbreak_magazine_theme_options',
		'title' => esc_html__( 'Header Options', 'newsbreak-magazine' ),
	)
);

// Header Section - Advertisement.
$wp_customize->add_setting(
	'newsbreak_magazine_header_advertisement',
	array(
		'default'           => '',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'newsbreak_magazine_header_advertisement',
		array(
			'label'    => esc_html__( 'Advertisement Image', 'newsbreak-magazine' ),
			'section'  => 'newsbreak_magazine_header_options',
			'settings' => 'newsbreak_magazine_header_advertisement',
		)
	)
);

// Header Section - Advertisement URL.
$wp_customize->add_setting(
	'newsbreak_magazine_header_advertisement_url',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_header_advertisement_url',
	array(
		'label'    => esc_html__( 'Advertisement URL', 'newsbreak-magazine' ),
		'section'  => 'newsbreak_magazine_header_options',
		'settings' => 'newsbreak_magazine_header_advertisement_url',
		'type'     => 'url',
	)
);
