<?php
/**
 * Excerpt
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_excerpt_options',
	array(
		'panel' => 'newsbreak_magazine_theme_options',
		'title' => esc_html__( 'Excerpt', 'newsbreak-magazine' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'newsbreak_magazine_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'newsbreak-magazine' ),
		'section'     => 'newsbreak_magazine_excerpt_options',
		'settings'    => 'newsbreak_magazine_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'max'  => 200,
			'step' => 1,
		),
	)
);
