<?php
/**
 * Breadcrumb
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_breadcrumb',
	array(
		'title' => esc_html__( 'Breadcrumb', 'newsbreak-magazine' ),
		'panel' => 'newsbreak_magazine_theme_options',
	)
);

// Breadcrumb - Enable Breadcrumb.
$wp_customize->add_setting(
	'newsbreak_magazine_enable_breadcrumb',
	array(
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_enable_breadcrumb',
		array(
			'label'   => esc_html__( 'Enable Breadcrumb', 'newsbreak-magazine' ),
			'section' => 'newsbreak_magazine_breadcrumb',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'newsbreak_magazine_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'newsbreak-magazine' ),
		'active_callback' => 'newsbreak_magazine_is_breadcrumb_enabled',
		'section'         => 'newsbreak_magazine_breadcrumb',
	)
);
