<?php
/**
 * Archive Layout
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_archive_layout',
	array(
		'title' => esc_html__( 'Archive Layout', 'newsbreak-magazine' ),
		'panel' => 'newsbreak_magazine_theme_options',
	)
);

// Archive Layout - Grid Style.
$wp_customize->add_setting(
	'newsbreak_magazine_archive_grid_style',
	array(
		'default'           => 'grid-column-3',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_archive_grid_style',
	array(
		'label'   => esc_html__( 'Grid Style', 'newsbreak-magazine' ),
		'section' => 'newsbreak_magazine_archive_layout',
		'type'    => 'select',
		'choices' => array(
			'grid-column-2' => __( 'Column 2', 'newsbreak-magazine' ),
			'grid-column-3' => __( 'Column 3', 'newsbreak-magazine' ),
		),
	)
);
