<?php
/**
 * Banner Section
 *
 * @package Newsbreak Magazine
 */

$wp_customize->add_section(
	'newsbreak_magazine_banner_section',
	array(
		'panel'    => 'newsbreak_magazine_front_page_options',
		'title'    => esc_html__( 'Banner Section', 'newsbreak-magazine' ),
		'priority' => 20,
	)
);

// Banner Section - Enable Section.
$wp_customize->add_setting(
	'newsbreak_magazine_enable_banner_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'newsbreak_magazine_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Toggle_Switch_Custom_Control(
		$wp_customize,
		'newsbreak_magazine_enable_banner_section',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'newsbreak-magazine' ),
			'section'  => 'newsbreak_magazine_banner_section',
			'settings' => 'newsbreak_magazine_enable_banner_section',
			'priority' => 10,
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'newsbreak_magazine_enable_banner_section',
		array(
			'selector' => '#newsbreak_magazine_banner_section .section-link',
			'settings' => 'newsbreak_magazine_enable_banner_section',
		)
	);
}

// Banner Section - Section Title.
$wp_customize->add_setting(
	'newsbreak_magazine_banner_title',
	array(
		'default'           => __( 'Main News', 'newsbreak-magazine' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_banner_title',
	array(
		'label'           => esc_html__( 'Section Title', 'newsbreak-magazine' ),
		'section'         => 'newsbreak_magazine_banner_section',
		'settings'        => 'newsbreak_magazine_banner_title',
		'type'            => 'text',
		'active_callback' => 'newsbreak_magazine_is_banner_posts_section_enabled',
		'priority'        => 20,
	)
);

// Banner Section - Banner Posts Content Type.
$wp_customize->add_setting(
	'newsbreak_magazine_banner_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_banner_posts_content_type',
	array(
		'label'           => esc_html__( 'Select Banner\'s Posts Content Type', 'newsbreak-magazine' ),
		'section'         => 'newsbreak_magazine_banner_section',
		'settings'        => 'newsbreak_magazine_banner_posts_content_type',
		'type'            => 'select',
		'active_callback' => 'newsbreak_magazine_is_banner_posts_section_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'newsbreak-magazine' ),
			'category' => esc_html__( 'Category', 'newsbreak-magazine' ),
		),
		'priority'        => 30,
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Banner Section - Select Post.
	$wp_customize->add_setting(
		'newsbreak_magazine_banner_posts_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'newsbreak_magazine_banner_posts_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'newsbreak-magazine' ), $i ),
			'section'         => 'newsbreak_magazine_banner_section',
			'settings'        => 'newsbreak_magazine_banner_posts_content_post_' . $i,
			'active_callback' => 'newsbreak_magazine_is_banner_posts_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => newsbreak_magazine_get_post_choices(),
			'priority'        => 40,
		)
	);

}

// Banner Section - Select Category.
$wp_customize->add_setting(
	'newsbreak_magazine_banner_posts_content_category',
	array(
		'sanitize_callback' => 'newsbreak_magazine_sanitize_select',
	)
);

$wp_customize->add_control(
	'newsbreak_magazine_banner_posts_content_category',
	array(
		'label'           => esc_html__( 'Select Category', 'newsbreak-magazine' ),
		'section'         => 'newsbreak_magazine_banner_section',
		'settings'        => 'newsbreak_magazine_banner_posts_content_category',
		'active_callback' => 'newsbreak_magazine_is_banner_posts_section_and_content_type_category_enabled',
		'type'            => 'select',
		'choices'         => newsbreak_magazine_get_post_cat_choices(),
		'priority'        => 50,
	)
);

// Banner Section - Horizontal Line.
$wp_customize->add_setting(
	'newsbreak_magazine_banner_posts_horizontal_line',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Newsbreak_Magazine_Customize_Horizontal_Line(
		$wp_customize,
		'newsbreak_magazine_banner_posts_horizontal_line',
		array(
			'section'         => 'newsbreak_magazine_banner_section',
			'settings'        => 'newsbreak_magazine_banner_posts_horizontal_line',
			'active_callback' => 'newsbreak_magazine_is_banner_posts_section_enabled',
			'type'            => 'hr',
			'priority'        => 60,
		)
	)
);
