(function(api) {

    api.sectionConstructor['newsbreak-magazine-upsell'] = api.Section.extend({

        // Remove events for this section.
        attachEvents: function() {},

        // Ensure this section is active. Normally, sections without contents aren't visible.
        isContextuallyActive: function() {
            return true;
        }
    });

    const newsbreak_magazine_section_lists = ['flash-news', 'banner'];
    newsbreak_magazine_section_lists.forEach(newsbreak_magazine_homepage_scroll);

    function newsbreak_magazine_homepage_scroll(item, index) {
        // Detect when the front page sections section is expanded (or closed) so we can adjust the preview accordingly.
        item = item.replace(/-/g, '_');
        wp.customize.section('newsbreak_magazine_' + item + '_section', function(section) {
            section.expanded.bind(function(isExpanding) {
                // Value of isExpanding will = true if you're entering the section, false if you're leaving it.
                wp.customize.previewer.send(item, { expanded: isExpanding });
            });
        });
    }
    
})(wp.customize);