<?php
/**
 * Template Name: Archive
 */

get_header(); ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="featured-image">
		<?php
					
					if ( has_post_thumbnail() && ! post_password_required() ) : ?>
						<figure class="entry-thumbnail"><?php the_post_thumbnail(); ?></figure>
					<?php endif; ?>

	</div>
				
	<div class="entry-box">	
		<!-- Article header -->
				<header class="entry-header"> 
					<h1 class="entry-title"><?php the_title(); ?></h1>
				</header> <!-- end entry-header -->
		<div class="entry-content">
			<div class="archives-list">	
				<h2 ><?php _e( 'Pages:', 'newsblog' ); ?></h2>
				<ul class="archive-pages">
					<?php wp_list_pages('title_li='); ?>
				</ul>
			

		
				<h2 ><?php _e( 'Recent Posts:', 'newsblog' ); ?></h2>
				<ul class="archive-recent">
					<?php 	$recent_posts = wp_get_recent_posts();
							foreach( $recent_posts as $recent ){
							echo '<li><a href="' . get_permalink($recent["ID"]) . '" title="Look '.esc_attr($recent["post_title"]).'" >' .   $recent["post_title"].'</a> </li> '; } ?>
				</ul>

				<h2 ><?php _e( 'Monthly:', 'newsblog' ); ?></h2>
				<ul class="archive-monthly">
					<?php wp_get_archives( 'show_post_count=1' ); ?>
				</ul>

				<h2 ><?php _e( 'Categories:', 'newsblog' ); ?></h2>
				<ul class="archive-categories">
					<?php wp_list_categories( 'show_count=1&title_li=' ); ?>
				</ul>

				<h2 ><?php _e( 'Author(s):', 'newsblog' ); ?></h2>
				<ul class="archive-authors">
					<?php wp_list_authors( 'optioncount=1' ); ?>
				</ul>
			</div>
			</div>
</div>
</article>
<?php get_footer(); ?>  