<?php 
/**
 * page.php
 *
 * The template for displaying all pages.
 */
?>

<?php get_header(); ?>

	
		<?php while( have_posts() ) : the_post(); ?>
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
				<?php
					// If the post has a thumbnail and it's not password protected
					// then display the thumbnail
					if ( has_post_thumbnail() && ! post_password_required() ) : ?>
				<div class="featured-image">
						<?php the_post_thumbnail(); ?>
				</div>
				<?php endif; ?>
				
				<div class="entry-box">
				<!-- Article header -->
				<header class="entry-header"> 
				<h1 class="entry-title"><?php the_title(); ?></h1>	
				</header> <!-- end entry-header -->

				<!-- Article content -->
				<div class="entry-content">
					<?php the_content(); ?>

					<?php wp_link_pages(); ?>
				</div> <!-- end entry-content -->

				<!-- Article footer -->
				<footer class="entry-footer">
					<?php 
						if ( is_user_logged_in() ) {
							echo '<p>';
							edit_post_link( __( 'Edit', 'newsblog' ), '<span class="meta-edit">', '</span>' );
							echo '</p>';
						}
					?>
				</footer> <!-- end entry-footer -->
			</article>
						<?php comments_template(); ?>
</div>

		<?php endwhile; ?>
	



<?php get_footer(); ?>