<?php 
/**
 * header.php
 *
 * The header for the theme.
 */
?>

<!DOCTYPE html>
<!--[if IE 8]> <html <?php language_attributes(); ?> class="ie8"> <![endif]-->
<!--[if !IE]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<title><?php wp_title( '|', true, 'right' ); ?></title>
	<meta name="description" content="<?php bloginfo( 'description' ); ?>">

	<!-- Mobile Specific Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">



	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>




<div class="site-top">
		<div class="search-box">
			<div class="inner">
				<?php get_search_form();?>
					</div><!-- .inner -->
		</div><!-- .search-box -->
		<nav role="navigation" class="site-nav">
			<div class="inner">
				<h3 class="icon-bars" id="menu-toggle">Menu</h3>
				<div class="nav-menu">
					
					<?php 
							wp_nav_menu(
								array(
									'theme_location' => 'main-menu',
									'menu_class' => 'site-menu'
								)
							);
						?>

				</div>				
<a class="icon-search" id="search-toggle" href="#"><span class="screen-reader-text">Search</span></a>
			</div><!-- .inner -->
		</nav><!-- .site-nav -->
	
	</div>

	<header role="banner" class="site-header">
		<div class="inner">
			<h1 class="site-title"><a class="logo-text" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('title');?></a></h1>
			<p class="site-description"><?php bloginfo('description');?></p>
					</div><!-- .inner -->
	</header>
	

	<!-- MAIN CONTENT AREA -->
<div role="main" class="content">
		<div class="container">



