<?php 
/**
 * functions.php
 *
 * The theme's functions and definitions.
 */

/**
 * ----------------------------------------------------------------------------------------
 * 1.0 - Define constants.
 * ----------------------------------------------------------------------------------------
 */
define( 'NEWSBLOG_THEMEROOT', get_stylesheet_directory_uri() );
define( 'NEWSBLOG_IMAGES', NEWSBLOG_THEMEROOT . '/images' );
define( 'SCRIPTS', NEWSBLOG_THEMEROOT . '/js' );
define( 'NEWSBLOG_FRAMEWORK', get_template_directory() . '/framework' );


/**
 * ----------------------------------------------------------------------------------------
 * 2.0 - Filter For Wp Title
 * ----------------------------------------------------------------------------------------
*/

function newsblog_mayer_wp_title( $title, $sep ) {
global $paged, $page;
if ( is_feed() ) {
return $title;
} // end if
// Add the site name.
$title .= get_bloginfo( 'name' );
// Add the site description for the home/front page.
$site_description = get_bloginfo( 'description', 'display' );
if ( $site_description && ( is_home() || is_front_page() ) ) {
$title = "$title $sep $site_description";
} // end if
// Add a page number if necessary.
if ( $paged >= 2 || $page >= 2 ) {
$title = sprintf( __( 'Page %s', 'mayer' ), max( $paged, $page ) ) . " $sep $title";
} // end if
return $title;
} // end mayer_wp_title
add_filter( 'wp_title', 'newsblog_mayer_wp_title', 10, 2 ); 



/**
 * ----------------------------------------------------------------------------------------
 * 3.0 - Set up the content width value based on the theme's design.
 * ----------------------------------------------------------------------------------------
 */
if ( ! isset( $content_width ) ) {
	$content_width = 1004;
}


/**
 * ----------------------------------------------------------------------------------------
 * 4.0 - Set up theme default and register various supported features.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_setup' ) ) {
	function newsblog_setup() {
		/**
		 * Make the theme available for translation.
		 */
		$lang_dir = NEWSBLOG_THEMEROOT . '/languages';
		load_theme_textdomain( 'newsblog', $lang_dir );

		/**
		 * Add support for post formats.
		 */
		add_theme_support( 'post-formats',
			array(
				'gallery',
				'link',
				'image',
				'quote',
				'video',
				'audio'
			)
		);

		/**
		 * Add support for automatic feed links.
		 */
		add_theme_support( 'automatic-feed-links' );


		/**
		 * Add support for post thumbnails.
		 */
		add_theme_support( 'post-thumbnails' );

		/**
		 * Register nav menus.
		 */
		register_nav_menus(
			array(
				'main-menu' => __( 'Main Menu', 'newsblog' )
			)
		);
	}

	add_action( 'after_setup_theme', 'newsblog_setup' );
}


/**
 * ----------------------------------------------------------------------------------------
 * 5.0 - Display meta information for a specific post.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_post_meta' ) ) {
	function newsblog_post_meta() {
	
		if ( get_post_type() === 'post' ) {
			// If the post is sticky, mark it.
			if ( is_sticky() ) {
				echo '<span aria-hidden="true" class="featured-post icon-pushpin"></span> ';
			}

			// Get the post author.
			printf(

				'<span class="byline"><span class="author vcard"><a rel="author" href="%1$s" class="url fn n">%2$s</a></span></span>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				get_the_author()
			);

			// Get the date.
			echo ' ' . get_the_date() . ' ';

			// The categories.
			$category_list = get_the_category_list( ', ' );
			if ( $category_list ) {
				echo ' ' . $category_list . ' ';
			}

			// The tags.
			$tag_list = get_the_tag_list( '', ', ' );
			if ( $tag_list ) {
				echo ' ' . $tag_list . ' ';
			}

			// Comments link.
			if ( comments_open() ) :
			
				echo '<span class="meta-reply">';
				comments_popup_link( __( 'Leave a comment', 'newsblog' ), __( 'One comment so far', 'newsblog' ), __( 'View all % comments', 'newsblog' ) );
				echo '</span>';
				
			endif;

			// Edit link.
			if ( is_user_logged_in() ) {
			
				edit_post_link( __( 'Edit', 'newsblog' ), '<span class="meta-edit">', '</span>' );
				
			}
		}
	}
}


/**
 * ----------------------------------------------------------------------------------------
 * 6.0 - Display navigation to the next/previous set of posts.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_paging_nav' ) ) {
	function newsblog_paging_nav() { ?>
		<nav class="post-nav">

			<?php 
				if ( get_next_posts_link() ) : ?>
			
					<?php next_posts_link( __( '&larr; Older Posts', 'newsblog' ) ); ?>
			
				<?php endif;
			 ?>

			<?php 
				if ( get_previous_posts_link() ) : ?>
				
					<?php previous_posts_link( __( 'Newer Posts &rarr;', 'newsblog' ) ); ?>
				
				<?php endif;
			 ?>
			
		</nav> <?php
	}
}


/**
 * ----------------------------------------------------------------------------------------
 * 7.0 - Register the widget areas.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_widget_init' ) ) {
	function newsblog_widget_init() {
		if ( function_exists( 'register_sidebar' ) ) {

			register_sidebar(
				array(
					'name' => __( 'Sidebar Widget Area', 'newsblog' ),
					'id' => 'sidebar-1',
					'description' => __( 'Appears on the sidebar.', 'newsblog' ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' => '</div> <!-- end widget -->',
					'before_title' => '<h5 class="widget-title">',
					'after_title' => '</h5>',
				)
			);

			register_sidebar(
				array(
					'name' => __( 'Footer Widget Area', 'newsblog' ),
					'id' => 'sidebar-2',
					'description' => __( 'Appears on the footer.', 'newsblog' ),
					'before_widget' => '<div id="%1$s" class="widget one-third %2$s">',
					'after_widget' => '</div> <!-- end widget -->',
					'before_title' => '<h5 class="widget-title">',
					'after_title' => '</h5>',
				)
			);
		}
	}

	add_action( 'widgets_init', 'newsblog_widget_init' );
}

/**
 * ----------------------------------------------------------------------------------------
 * 8.0 - Function that validates a field's length.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_validate_length' ) ) {
	function newsblog_validate_length( $fieldValue, $minLength ) {
		// First, remove trailing and leading whitespace
		return ( strlen( trim( $fieldValue ) ) > $minLength );
	}
}



/**
 * ----------------------------------------------------------------------------------------
 * 10.0 - Load the custom scripts for the theme.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'newsblog_scripts' ) ) {
	function newsblog_scripts() {
		// Adds support for pages with threaded comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Register scripts
		wp_register_script( 'bootstrap-js', SCRIPTS . '/bootstrap.min.js', array( 'jquery' ), false, true );
		wp_register_script( 'newsblog-custom', SCRIPTS . '/scripts.js', array( 'jquery' ), false, true );

		// Load the custom scripts
		wp_enqueue_script( 'bootstrap-js' );
		wp_enqueue_script( 'newsblog-custom' );

		// Load the stylesheets
		wp_enqueue_style( 'newsblog-master', NEWSBLOG_THEMEROOT . '/css/master.css' );
		wp_enqueue_style( 'bootstrap-style', NEWSBLOG_THEMEROOT . '/css/bootstrap.min.css' );
		wp_enqueue_style( 'newsblog-components', NEWSBLOG_THEMEROOT . '/css/components.css' );

	}

	add_action( 'wp_enqueue_scripts', 'newsblog_scripts' );
}

/**
 * ----------------------------------------------------------------------------------------
 * 11.0 - Include the generated CSS for the featured image thumbnail.
 * ----------------------------------------------------------------------------------------
 */

if (!function_exists('newsblog_featured_image_bg')) {
	function newsblog_featured_image_bg(){

		$newsblog_featured_image_bg = wp_get_attachment_url( get_post_thumbnail_id($post->ID) );

		?>
		
		

		<div class="featured-image-bg" style="background-image:url('<?php echo $newsblog_featured_image_bg; ?>'); " ></div>


<?php

	}
}

?>