<?php 
/**
 * content.php
 *
 * The default template for displaying content.
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>



<?php
		// If the post has a thumbnail and it's not password protected
		// then display the thumbnail
		if ( has_post_thumbnail() && ! post_password_required() ) : ?>
			<figure class="entry-thumbnail"><?php the_post_thumbnail(); ?></figure>
		<?php endif;?>


<div class="entry-box">	

	<!-- Article header -->
	<header class="entry-header">
<?php
		// If single page, display the title
		// Else, we display the title in a link
		if ( is_single() ) : ?>
			<h1 class="entry-title"><?php the_title(); ?></h1>
		<?php else : ?>
			<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>
		<?php endif; ?>

		

		<div class="entry-meta">
			<?php 
				// Display the meta information
				newsblog_post_meta();
			?>
		</div>
	</header> <!-- end entry-header -->

	<!-- Article content -->
	<div class="entry-content">
		<?php
			if ( is_search() ) {
				the_excerpt();
			} else {
				the_content( __( 'Continue reading &rarr;', 'newsblog' ) );

				wp_link_pages();
			}
		?>
	</div> <!-- end entry-content -->

	<!-- Article footer -->
	<footer class="entry-footer">
		
	</footer> <!-- end entry-footer -->
	</div>
	


<?php 
			// If we have a single page and the author bio exists, display it
			if ( is_single() && get_the_author_meta( 'description' ) ) {
				echo '<div class="author-box"><div class="author-info">';
				echo get_avatar( get_the_author_meta( 'user_email' ));
				echo '<h3 class="author-title">' . __( 'Written by ', 'newsblog' ) . get_the_author() . '</h3>';
				echo '<p class="author-bio">' . get_the_author_meta( 'description' ) . '</p>';
				echo '</div></div>';
			}
		?>
		
</article>