<?php 
/**
 * content-link.php
 *
 * The default template for displaying posts with the Link post format.
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="entry-box">

	<header class="entry-header">
			<h1 class="entry-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title();?></a></h1>			<div class="entry-meta">
			<?php 
				// Display the meta information
				newsblog_post_meta();
			?>		</div>
		</header>


	<!-- Article content -->
	<div class="entry-content">
		<?php
			the_content( __( 'Continue reading &rarr;', 'newsblog' ) );

			wp_link_pages();
		?>
	</div> <!-- end entry-content -->

	</div>
	<?php 
			// If we have a single page and the author bio exists, display it
			if ( is_single() && get_the_author_meta( 'description' ) ) {
				echo '<div class="author-box"><div class="author-info">';
				echo get_avatar( get_the_author_meta( 'user_email' ));
				echo '<h3 class="author-title">' . __( 'Written by ', 'newsblog' ) . get_the_author() . '</h3>';
				echo '<p class="author-bio">' . get_the_author_meta( 'description' ) . '</p>';
				echo '</div></div>';
			}
		?>
		
</article>