<?php 
/**
 * comments.php
 *
 * The template for displaying comments.
 */
?>


<?php 
	// If the post is password protected, display info text and return.
	if ( post_password_required() ) : ?>
		<p>
			<?php 
				_e( 'This post is password protected. Enter the password to view the comments.', 'newsblog' );

				return;
			?>
		</p>
	<?php endif; ?>

<!-- Comments Area -->
<div class="comments-area" id="comments">
	<?php if ( have_comments() ) : ?>
		<h3 id="comments-title">
			<?php 
				printf( _nx( 'One comment', '%1$s comments', get_comments_number(), 'Comment title', 'newsblog' ), number_format_i18n( get_comments_number() ) );
			?>
		</h3>

		<ol class="comment-list">
			<?php wp_list_comments(); ?>
		</ol>

		<?php 
			// If the comments are paginated, display the controls.
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
		?>
		<nav class="comment-nav" role="navigation">
			<p class="comment-nav-prev">
				<?php previous_comments_link( __( '&larr; Older Comments', 'newsblog' ) ); ?>
			</p>

			<p class="comment-nav-next">
				<?php next_comments_link( __( 'Newer Comments &rarr;', 'newsblog' ) ); ?>
			</p>
		</nav> <!-- end comment-nav -->
		<?php endif; ?>

		<?php 
			// If the comments are closed, display an info text.
			if ( ! comments_open() && get_comments_number() ) :
		?>
			<p class="no-comments">
				<?php _e( 'Comments are closed.', 'newsblog' ); ?>
			</p>
		<?php endif; ?>
	<?php endif; ?>

	<?php comment_form(); ?>
</div> <!-- end comments-area -->