<?php 
/**
 * author.php
 *
 * The template for displaying author archive pages.
 */
?>

<?php get_header(); ?>

	<div class="main-content col-md-8" role="main">
		<?php if ( have_posts() ) : the_post(); ?>
			<header class="page-header">
				<h1 class="page-title">
					<?php printf( __( 'All posts by <span class="highlight">%s</span>', 'newsblog' ), get_the_author() ); ?>
				</h1>

				<div class="author-box">
							<div class="author-info">
								
								<h3 class="author-title"><?php printf( __( 'About <span class="highlight">%s</span>', 'newsblog' ), get_the_author() ); ?></h3>
								<p class="author-bio"><?php 
					// If the author bio exists, display it.
					if ( get_the_author_meta( 'description' ) ) {
						echo '<p>' . the_author_meta( 'description' ) . '</p>';
					}
				?></p>
							</div><!-- .author-info -->
						</div>

				

				<?php rewind_posts(); ?>
			</header>

			<?php while( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<?php newsblog_paging_nav(); ?>
		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>
	</div> <!-- end main-content -->

<?php get_footer(); ?>