<?php 
/**
 * archive.php
 *
 * The template for displaying archive pages.
 */
?>

<?php get_header(); ?>

	
		<?php if ( have_posts() ) : ?>
			<header class="page-header">
				<h1 class="page-title">
					<?php 
						if ( is_day() ) {
							printf( __( 'Daily Archives for <span class="highlight">%s</span>', 'newsblog' ), get_the_date() );
						} elseif ( is_month() ) {
							printf( __( 'Monthly Archives for <span class="highlight">%s</span>', 'newsblog' ), get_the_date( _x( 'F Y', 'Monthly archives date format', 'newsblog' ) ) );
						} elseif ( is_year() ) {
							printf( __( 'Yearly Archives for <span class="highlight">%s</span>', 'newsblog' ), get_the_date( _x( 'Y', 'Yearly archives date format', 'newsblog' ) ) );
						} else {
							_e( 'Archives', 'newsblog' );
						}
					?>
				</h1>
			</header>

			<?php while( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<?php newsblog_paging_nav(); ?>
		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

<?php get_footer(); ?>