<?php
// Fetch all options at once (cleaner).
$options = [
    'enable_main_banner_section' => newsberry_get_option('enable_main_banner_section'),
    'banner_list_post_title' => newsberry_get_option('banner_list_post_title'),
    'banner_list_post_category' => newsberry_get_option('banner_list_post_category'),
    'banner_grid_post_category' => newsberry_get_option('banner_grid_post_category'),
    'enable_banner_author_meta' => newsberry_get_option('enable_banner_author_meta'),
    'select_banner_author_meta' => newsberry_get_option('select_banner_author_meta'),
    'banner_author_meta_title' => newsberry_get_option('banner_author_meta_title'),
    'enable_banner_date_meta' => newsberry_get_option('enable_banner_date_meta'),
    'select_banner_date' => newsberry_get_option('select_banner_date'),
    'select_banner_date_meta_title' => newsberry_get_option('select_banner_date_meta_title'),
    'select_banner_date_format' => newsberry_get_option('select_banner_date_format'),
    'enable_banner_category_meta' => newsberry_get_option('enable_banner_category_meta'),
    'banner_category_label' => newsberry_get_option('banner_category_label'),
    'select_banner_category_color' => newsberry_get_option('select_banner_category_color'),
    'select_banner_number_of_category' => newsberry_get_option('select_banner_number_of_category')
];
if (empty($options['enable_main_banner_section'])) return;
// Helper to display post meta.
function display_post_meta($options)
{
    if ($options['enable_banner_date_meta']) {
        newsberry_posted_on($options['select_banner_date_format'], $options['select_banner_date_meta_title'], $options['select_banner_date']);
    }
    if ($options['enable_banner_author_meta']) {
        newsberry_posted_by($options['select_banner_author_meta'], $options['banner_author_meta_title']);
    }
}
// Helper to display post categories.
function display_post_categories($options)
{
    if ($options['enable_banner_category_meta']) {
        newsberry_post_category($options['select_banner_category_color'], $options['banner_category_label'], $options['select_banner_number_of_category']);
    }
}
?>
<section class="wpi-section wpi-banner-section">
    <div class="wrapper">
        <div class="row-group">
            <?php
            // 1. Grid posts section
            $grid_args = [
                'post_type' => 'post',
                'posts_per_page' => 3,
                'post_status' => 'publish',
                'no_found_rows' => 1,
                'ignore_sticky_posts' => 1
            ];
            if (!empty($options['banner_grid_post_category'])) {
                $grid_args['tax_query'] = [[
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $options['banner_grid_post_category']
                ]];
            }
            $grid_posts = new WP_Query($grid_args);
            if ($grid_posts->have_posts()) :
                $counts = 1;
                echo '<div class="column-lg-6 column-md-12 column-sm-12">';
                while ($grid_posts->have_posts()) : $grid_posts->the_post();
                    $image_classes = [
                        1 => ['entry-image-large', 'entry-title-big'],
                        2 => ['entry-image-medium', 'entry-title-medium'],
                        3 => ['entry-image-medium', 'entry-title-medium']
                    ];
                    [$image_class, $title_class] = $image_classes[$counts] ?? ['entry-image-small', 'entry-title-medium'];
                    ?>
                    <article id="banner-<?php echo ($counts == 1) ? 'prime' : 'center'; ?>-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-default' . (($counts != 1) ? ' wpi-post-banner-center' : '')); ?>>
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="entry-image <?php echo esc_attr($image_class); ?> image-hover-effect hover-effect-shine">
                                <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true"
                                   tabindex="-1">
                                    <?php the_post_thumbnail(($counts == 1) ? 'large' : 'medium', ['alt' => the_title_attribute(['echo' => false])]); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        <div class="entry-details">
                            <?php display_post_categories($options); ?>
                            <h3 class="entry-title <?php echo esc_attr($title_class); ?>">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h3>
                            <div class="entry-meta-wrapper">
                                <?php display_post_meta($options); ?>
                            </div>
                            <?php
                            if ($counts == 1) {
                                if (has_excerpt()) : ?>
                                    <div class="entry-content">
                                        <?php the_excerpt(); ?>
                                    </div>
                                <?php else : ?>
                                    <div class="entry-content">
                                        <?php echo esc_html(wp_trim_words(get_the_content(), 25, '...')); ?>
                                    </div>
                                <?php endif;
                            }
                            ?>
                        </div>
                    </article>
                    <?php
                    if ($counts == 1) echo '</div><div class="column-lg-3 column-md-6 column-sm-12">';
                    $counts++;
                endwhile;
                echo '</div>';
                wp_reset_postdata();
            endif;
            ?>
            <div class="column-lg-3 column-md-6 column-sm-12">
                <?php if (!empty($options['banner_list_post_title'])) : ?>
                    <header class="wpi-section-header">
                        <h2 class="section-header-title">
                            <?php echo esc_html($options['banner_list_post_title']); ?>
                        </h2>
                    </header>
                <?php endif; ?>
                <?php
                $list_args = [
                    'post_type' => 'post',
                    'posts_per_page' => 4,
                    'post_status' => 'publish',
                    'no_found_rows' => 1,
                    'ignore_sticky_posts' => 1
                ];
                if (!empty($options['banner_list_post_category'])) {
                    $list_args['tax_query'] = [[
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $options['banner_list_post_category']
                    ]];
                }
                $list_posts = new WP_Query($list_args);
                if ($list_posts->have_posts()) :
                    $count = 1;
                    while ($list_posts->have_posts()) : $list_posts->the_post();
                        $is_prime = ($count == 1);
                        ?>
                        <article
                                id="banner-left-<?php the_ID(); ?>" <?php post_class('wpi-post ' . ($is_prime ? 'wpi-post-default wpi-post-prime' : 'wpi-post-list')); ?>>
                            <?php if ($is_prime && has_post_thumbnail()) : ?>
                                <div class="entry-image entry-image-small image-hover-effect hover-effect-shine">
                                    <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true"
                                       tabindex="-1">
                                        <?php the_post_thumbnail('medium', ['alt' => the_title_attribute(['echo' => false])]); ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                            <div class="entry-details">
                                <?php display_post_categories($options); ?>
                                <h3 class="entry-title <?php echo $is_prime ? 'entry-title-medium' : 'entry-title-small'; ?>">
                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                </h3>
                                <div class="entry-meta-wrapper">
                                    <?php display_post_meta($options); ?>
                                </div>
                            </div>
                        </article>
                        <?php $count++;
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>
        </div>
    </div>
</section>