<?php
/**
 * NewsBerry Admin Class.
 *
 * @package NewsBerry
 * @since   1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('NewsBerry_Admin')) :
    /**
     * NewsBerry_Admin Class.
     */
    class NewsBerry_Admin
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
            add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        }

        /**
         * Localize array for import button AJAX request.
         */
        public function enqueue_scripts()
        {

            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            $file_name = is_rtl() ? 'admin-rtl' . $suffix . '.css' : 'admin' . $suffix . '.css';

            wp_enqueue_style(
                'newsberry-admin-style',
                get_template_directory_uri() . '/inc/admin/dashboard/css/' . $file_name,
                array(),
                NEWSBERRY_VERSION
            );


            wp_enqueue_script('newsberry-plugin-install-helper', get_template_directory_uri() . '/inc/admin/dashboard/js/admin.js', array('jquery'), NEWSBERRY_VERSION, true);
            $welcome_data = array(
                'uri' => esc_url(admin_url('/themes.php?page=newsberry&tab=starter-templates')),
                'btn_text' => esc_html__('Processing...', 'newsberry'),
                'nonce' => wp_create_nonce('newsberry_demo_import_nonce'),
                'admin_url' => esc_url(admin_url()),
                'ajaxurl' => admin_url('admin-ajax.php'), // Include this line for using admin-ajax.php
            );
            wp_localize_script('newsberry-plugin-install-helper', 'newsberryRedirectDemoPage', $welcome_data);
        }
    }
endif;
return new NewsBerry_Admin();
