<?php
// Tags Posts Options.
$wp_customize->add_section(
	'home_page_tags_options',
	array(
		'title' => __( 'Tagged Section', 'newsberry' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_tags]',
    array(
        'default'           => $newsberry_default['enable_tags'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_tags]',
    array(
		'label'    => __( 'Enable Tags', 'newsberry' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_tags_label]',
    array(
        'default'           => $newsberry_default['enable_tags_label'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_tags_label]',
    array(
		'label'           => __( 'Enable Tags Label', 'newsberry' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

// Tags Label Style.
$wp_customize->add_setting(
    'newsberry_options[tags_label_style]',
    array(
        'default'           => $newsberry_default['tags_label_style'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[tags_label_style]',
    array(
        'label'           => __( 'Label Style', 'newsberry' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'select',
        'choices'         => array(
            'style_1' => __( 'Plain', 'newsberry' ),
            'style_2' => __( 'With Icon', 'newsberry' ),
        ),
    )
);


// Tags Label Text.
$wp_customize->add_setting(
    'newsberry_options[tags_label_text]',
    array(
        'default'           => $newsberry_default['tags_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[tags_label_text]',
    array(
        'label'           => __( 'Tags Label Text', 'newsberry' ),
        'description'     => __( 'Leave empty if you want it blank', 'newsberry' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'text',
    )
);

// No of posts.
$wp_customize->add_setting(
    'newsberry_options[no_of_tags]',
    array(
        'default'           => $newsberry_default['no_of_tags'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[no_of_tags]',
    array(
		'label'           => __( 'Number of Tags', 'newsberry' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'number',
    )
);


// Posts Orderby.
$wp_customize->add_setting(
    'newsberry_options[tags_orderby]',
    array(
        'default'           => $newsberry_default['tags_orderby'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[tags_orderby]',
    array(
		'label'           => __( 'Orderby', 'newsberry' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'newsberry' ),
			'id'    => __( 'ID', 'newsberry' ),
			'title' => __( 'Title', 'newsberry' ),
			'rand'  => __( 'Random', 'newsberry' ),
		),
    )
);


// Posts Order.
$wp_customize->add_setting(
    'newsberry_options[tags_order]',
    array(
        'default'           => $newsberry_default['tags_order'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[tags_order]',
    array(
		'label'           => __( 'Orderby', 'newsberry' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'newsberry' ),
			'desc' => __( 'DESC', 'newsberry' ),
		),
    )
);


$wp_customize->add_setting(
    'newsberry_options[hide_tags_label_responsive]',
    array(
        'default'           => $newsberry_default['hide_tags_label_responsive'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[hide_tags_label_responsive]',
    array(
		'label'           => __( 'Hide Label on Responsive', 'newsberry' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);