<?php
$wp_customize->add_section(
    'homepage_slider_banner_option',
    array(
        'title' => __('Carousel Banner', 'newsberry'),
        'panel' => 'front_page_theme_options_panel',
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'newsberry_options[enable_slider_banner_section]',
    array(
        'default' => $newsberry_default['enable_slider_banner_section'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_slider_banner_section]',
    array(
        'label' => __('Enable Carousel Banner Section', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[title_slider_banner_section]',
    array(
        'default'           => $newsberry_default['title_slider_banner_section'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[title_slider_banner_section]',
    array(
        'label'    => __( 'Section Title', 'newsberry' ),
        'section'  => 'homepage_slider_banner_option',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[number_of_slider_post]',
    array(
        'default' => $newsberry_default['number_of_slider_post'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[number_of_slider_post]',
    array(
        'label' => __('Post In Slider', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            '3' => __('3', 'newsberry'),
            '4' => __('4', 'newsberry'),
            '5' => __('5', 'newsberry'),
            '6' => __('6', 'newsberry'),
        ),
    )
);


$wp_customize->add_setting(
    'newsberry_options[banner_section_cat]',
    array(
        'default'           => $newsberry_default['banner_section_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new Newsberry_Dropdown_Taxonomies_Control(
        $wp_customize,
        'newsberry_options[banner_section_cat]',
        array(
            'label'           => __( 'Choose  Category', 'newsberry' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'newsberry' ),
            'section'         => 'homepage_slider_banner_option',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_banner_post_description]',
    array(
        'default' => $newsberry_default['enable_banner_post_description'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_post_description]',
    array(
        'label' => __('Enable Post Description', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_banner_overlay]',
    array(
        'default' => $newsberry_default['enable_banner_overlay'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_overlay]',
    array(
        'label' => __('Enable Banner Overlay', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[slider_post_content_alignment]',
    array(
        'default' => $newsberry_default['slider_post_content_alignment'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[slider_post_content_alignment]',
    array(
        'label' => __('Content Vertical Alignment', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            'banner-description-top' => __('Vertical alignment top', 'newsberry'),
            'banner-description-space' => __('Vertical alignment space between', 'newsberry'),
            'banner-description-bottom' => __('Vertical alignment bottom', 'newsberry'),
        ),
    )
);

$wp_customize->add_setting(
    'newsberry_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Banner Slider Meta', 'newsberry' ),
            'settings' => 'newsberry_section_seperator_banner',
            'section' => 'homepage_slider_banner_option',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_banner_slider_author_meta]',
    array(
        'default' => $newsberry_default['enable_banner_slider_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_author_meta]',
    array(
        'default' => $newsberry_default['select_banner_slider_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => newsberry_author_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[banner_slider_author_meta_title]',
    array(
        'default' => $newsberry_default['banner_slider_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[banner_slider_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_banner_slider_date_meta]',
    array(
        'default' => $newsberry_default['enable_banner_slider_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_slider_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_date]',
    array(
        'default' => $newsberry_default['select_banner_slider_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_date]',
    array(
        'label' => esc_html__('Select Posted on Date Meta', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => newsberry_date_meta(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_date_meta_title]',
    array(
        'default' => $newsberry_default['select_banner_slider_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_date_meta_title]',
    array(
        'label' => __('Date Text', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_date_format]',
    array(
        'default' => $newsberry_default['select_banner_slider_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => newsberry_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'newsberry_options[enable_banner_slider_category_meta]',
    array(
        'default' => $newsberry_default['enable_banner_slider_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_slider_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_number_of_category]',
    array(
        'default' => $newsberry_default['select_banner_slider_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_number_of_category]',
    array(
        'label' => __('Number of Category', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'newsberry_options[banner_slider_category_label]',
    array(
        'default' => $newsberry_default['banner_slider_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[banner_slider_category_label]',
    array(
        'label' => __('Category Label', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_banner_slider_category_color]',
    array(
        'default' => $newsberry_default['select_banner_slider_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_banner_slider_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => newsberry_category_color(),
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'newsberry_options[enable_banner_control_icon]',
    array(
        'default' => $newsberry_default['enable_banner_control_icon'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_banner_control_icon]',
    array(
        'label' => __('Enable Slider Control', 'newsberry'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);