<?php
/**
 * All settings related to single.
 *
 * @package NewsBerry
 */
$wp_customize->add_section(
	'single_options',
	array(
		'title' => esc_html__( 'Single Page Options', 'newsberry' ),
		'panel' => 'single_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[enable_single_author_meta]',
    array(
        'default'           => $newsberry_default['enable_single_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_single_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_single_author_meta]',
    array(
        'default'           => $newsberry_default['select_single_author_meta'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_single_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'       => newsberry_author_meta(),


    )
);

$wp_customize->add_setting(
    'newsberry_options[single_author_meta_title]',
    array(
        'default'           => $newsberry_default['single_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[single_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'newsberry' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_single_date_meta]',
    array(
        'default'           => $newsberry_default['enable_single_date_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_single_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_single_date]',
    array(
        'default'           => $newsberry_default['select_single_date'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_single_date]',
    array(
        'label'         => esc_html__( 'Select Posted on Date Meta', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'       => newsberry_date_meta(),

    )
);

$wp_customize->add_setting(
    'newsberry_options[single_date_meta_title]',
    array(
        'default'           => $newsberry_default['single_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[single_date_meta_title]',
    array(
        'label'    => __( 'Date Text', 'newsberry' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_single_date_format]',
    array(
        'default'           => $newsberry_default['select_single_date_format'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_single_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'  		=> newsberry_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_single_category_meta]',
    array(
        'default'           => $newsberry_default['enable_single_category_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_single_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Single Category Meta', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'newsberry_options[single_category_label]',
    array(
        'default'           => $newsberry_default['single_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'newsberry_options[single_category_label]',
    array(
        'label'    => __( 'Category Title', 'newsberry' ),
        'section'  => 'single_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'newsberry_options[select_single_category_color]',
    array(
        'default'           => $newsberry_default['select_single_category_color'],
        'sanitize_callback' => 'newsberry_sanitize_select',
    )
);
$wp_customize->add_control(
    'newsberry_options[select_single_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'select',
        'choices'  		=> newsberry_category_color(),

    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_single_tag_meta]',
    array(
        'default'           => $newsberry_default['enable_single_tag_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_single_tag_meta]',
    array(
        'label'       => esc_html__( 'Enable Tag Meta', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'newsberry_options[enable_single_read_time_meta]',
    array(
        'default'           => $newsberry_default['enable_single_read_time_meta'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_single_read_time_meta]',
    array(
        'label'       => esc_html__( 'Enable Read Time', 'newsberry' ),
        'section'     => 'single_options',
        'type'        => 'checkbox',
    )
);



$wp_customize->add_setting(
    'newsberry_section_seperator_single_5',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_single_5',
        array(
            'settings' => 'newsberry_section_seperator_single_5',
            'section'       => 'single_options',
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[show_sticky_article_navigation]',
    array(
        'default'           => $newsberry_default['show_sticky_article_navigation'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[show_sticky_article_navigation]',
    array(
        'label'    => __( 'Show Sticky Article Navigation', 'newsberry' ),
        'section'  => 'single_options',
        'type'     => 'checkbox',
    )
);

/*Show Author Info Box start
*-------------------------------*/
$wp_customize->add_setting(
    'newsberry_section_seperator_single_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new Newsberry_Seperator_Control(
        $wp_customize,
        'newsberry_section_seperator_single_2',
        array(
            'settings' => 'newsberry_section_seperator_single_2',
            'section'       => 'single_options',
        )
    )
);

$wp_customize->add_setting(
    'newsberry_options[show_author_info]',
    array(
        'default'           => $newsberry_default['show_author_info'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[show_author_info]',
    array(
        'label'    => __( 'Show Author Info Box', 'newsberry' ),
        'section'  => 'single_options',
        'type'     => 'checkbox',
    )
);


$wp_customize->add_section(
    'single_sidebar_options',
    array(
        'title' => esc_html__( 'SideBar Options', 'newsberry' ),
        'panel' => 'single_options_panel',
    )
);

$wp_customize->add_setting(
    'newsberry_options[single_sidebar_layout_option]',
    array(
        'default'           => $newsberry_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[single_sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'newsberry' ),
            'section'       => 'single_sidebar_options',
            'choices'       => newsberry_get_sidebar_layouts(),
        )
    )
);




$wp_customize->add_setting(
    'newsberry_options[enable_sidebar_fix_single]',
    array(
        'default'           => $newsberry_default['enable_sidebar_fix_single'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_sidebar_fix_single]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'newsberry' ),
        'section'     => 'single_options_panel',
        'type'        => 'checkbox',
    )
);