<?php
$wp_customize->add_section(
	'sidebar_options',
	array(
		'title' => esc_html__( 'SideBar Options', 'newsberry' ),
		'panel' => 'archive_options_panel',
	)
);

$wp_customize->add_setting(
    'newsberry_options[sidebar_layout_option]',
    array(
        'default'           => $newsberry_default['sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (archive)', 'newsberry' ),
            'section'       => 'sidebar_options',
            'choices'       => newsberry_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[single_sidebar_layout_option]',
    array(
        'default'           => $newsberry_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'newsberry_sanitize_radio'
    )
);

$wp_customize->add_control(
    new Newsberry_Custom_Radio_Image_Control(
        $wp_customize,
        'newsberry_options[single_sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'newsberry' ),
            'section'       => 'sidebar_options',
            'choices'       => newsberry_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'newsberry_options[enable_sidebar_fix_archive]',
    array(
        'default'           => $newsberry_default['enable_sidebar_fix_archive'],
        'sanitize_callback' => 'newsberry_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'newsberry_options[enable_sidebar_fix_archive]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'newsberry' ),
        'section'     => 'sidebar_options',
        'type'        => 'checkbox',
    )
);
